/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.RowColumnResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.CellHistory;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.enums.CellHistoryInclusion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.HashMap;

public class RowColumnResourcesImpl
extends AbstractResources
implements RowColumnResources {
    public RowColumnResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<CellHistory> getCellHistory(long sheetId, long rowId, long columnId, PaginationParameters parameters) throws SmartsheetException {
        return this.getCellHistory(sheetId, rowId, columnId, parameters, null, null);
    }

    @Override
    public PagedResult<CellHistory> getCellHistory(long sheetId, long rowId, long columnId, PaginationParameters pagination, EnumSet<CellHistoryInclusion> includes, Integer level) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/history";
        HashMap<Object, Object> parameters = new HashMap();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        if (level != null) {
            parameters.put("level", level);
        }
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, CellHistory.class);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, String file, String contentType) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(file);
        File f = new File(file);
        this.addImage("sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/cellimages", new FileInputStream(f), contentType, f.length(), false, null, file);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, String file, String contentType, boolean overrideValidation, String altText) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(file);
        File f = new File(file);
        this.addImage("sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/cellimages", new FileInputStream(f), contentType, f.length(), overrideValidation, altText, file);
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, File file, String contentType, boolean overrideValidation, String altText) throws FileNotFoundException, SmartsheetException {
        Util.throwIfNull(file);
        this.addImage("sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/cellimages", new FileInputStream(file), contentType, file.length(), overrideValidation, altText, file.getName());
    }

    @Override
    public void addImageToCell(long sheetId, long rowId, long columnId, InputStream inputStream, String contentType, long contentLength, boolean overrideValidation, String altText) throws SmartsheetException {
        Util.throwIfNull(inputStream);
        this.addImage("sheets/" + sheetId + "/rows/" + rowId + "/columns/" + columnId + "/cellimages", inputStream, contentType, contentLength, overrideValidation, altText, altText);
    }

    private void addImage(String path, InputStream inputStream, String contentType, long contentLength, boolean overrideValidation, String altText, String imageName) throws SmartsheetException {
        if (imageName == null) {
            inputStream.toString();
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (altText != null) {
            parameters.put("altText", altText);
        }
        if (overrideValidation) {
            parameters.put("overrideValidation", "true");
        }
        path = (String)path + QueryUtil.generateUrl(null, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve((String)path), HttpMethod.POST);
        try {
            request.getHeaders().put("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(imageName, "UTF-8") + "\"");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HttpEntity entity = new HttpEntity();
        entity.setContentType(contentType);
        entity.setContent(inputStream);
        entity.setContentLength(contentLength);
        request.setEntity(entity);
        HttpResponse response = this.smartsheet.getHttpClient().request(request);
        switch (response.getStatusCode()) {
            case 200: {
                break;
            }
            default: {
                this.handleError(response);
            }
        }
        this.smartsheet.getHttpClient().releaseConnection();
    }
}

