/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.SheetColumnResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Column;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.enums.ColumnInclusion;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public class SheetColumnResourcesImpl
extends AbstractResources
implements SheetColumnResources {
    public SheetColumnResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public PagedResult<Column> listColumns(long sheetId, EnumSet<ColumnInclusion> includes, PaginationParameters pagination) throws SmartsheetException {
        return this.listColumns(sheetId, includes, pagination, null);
    }

    @Override
    public PagedResult<Column> listColumns(long sheetId, EnumSet<ColumnInclusion> includes, PaginationParameters pagination, Integer level) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/columns";
        HashMap<Object, Object> parameters = new HashMap<String, String>();
        if (pagination != null) {
            parameters = pagination.toHashMap();
        }
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("level", level);
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.listResourcesWithWrapper(path, Column.class);
    }

    @Override
    public List<Column> addColumns(long sheetId, List<Column> columns) throws SmartsheetException {
        return this.postAndReceiveList("sheets/" + sheetId + "/columns", columns, Column.class);
    }

    @Override
    public void deleteColumn(long sheetId, long columnId) throws SmartsheetException {
        this.deleteResource("sheets/" + sheetId + "/columns/" + columnId, Column.class);
    }

    @Override
    public Column updateColumn(long sheetId, Column column) throws SmartsheetException {
        Util.throwIfNull(column);
        return this.updateResource("sheets/" + sheetId + "/columns/" + column.getId(), Column.class, column);
    }

    @Override
    public Column getColumn(long sheetId, long columnId, EnumSet<ColumnInclusion> includes) throws SmartsheetException {
        Object path = "sheets/" + sheetId + "/columns/" + columnId;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = QueryUtil.generateUrl((String)path, parameters);
        return this.getResource((String)path, Column.class);
    }
}

