/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.RowAttachmentResources;
import com.smartsheet.api.RowColumnResources;
import com.smartsheet.api.RowDiscussionResources;
import com.smartsheet.api.SheetRowResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.RowAttachmentResourcesImpl;
import com.smartsheet.api.internal.RowColumnResourcesImpl;
import com.smartsheet.api.internal.RowDiscussionResourcesImpl;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.http.HttpMethod;
import com.smartsheet.api.internal.http.HttpRequest;
import com.smartsheet.api.internal.http.HttpResponse;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.BulkItemFailure;
import com.smartsheet.api.models.BulkItemResult;
import com.smartsheet.api.models.BulkRowFailedItem;
import com.smartsheet.api.models.Cell;
import com.smartsheet.api.models.CopyOrMoveRowDirective;
import com.smartsheet.api.models.CopyOrMoveRowResult;
import com.smartsheet.api.models.MultiRowEmail;
import com.smartsheet.api.models.PartialRowUpdateResult;
import com.smartsheet.api.models.Row;
import com.smartsheet.api.models.RowEmail;
import com.smartsheet.api.models.enums.ObjectExclusion;
import com.smartsheet.api.models.enums.RowCopyInclusion;
import com.smartsheet.api.models.enums.RowInclusion;
import com.smartsheet.api.models.enums.RowMoveInclusion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SheetRowResourcesImpl
extends AbstractResources
implements SheetRowResources {
    RowAttachmentResources attachments;
    RowDiscussionResources discussions;
    RowColumnResources columns;

    public SheetRowResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
        this.attachments = new RowAttachmentResourcesImpl(smartsheet);
        this.discussions = new RowDiscussionResourcesImpl(smartsheet);
        this.columns = new RowColumnResourcesImpl(smartsheet);
    }

    @Override
    public List<Row> addRows(long sheetId, List<Row> rows) throws SmartsheetException {
        return this.addRows(sheetId, rows, null, null);
    }

    @Override
    public List<Row> addRows(long sheetId, List<Row> rows, EnumSet<RowInclusion> includes, EnumSet<ObjectExclusion> excludes) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/rows";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.postAndReceiveList(path, rows, Row.class);
    }

    @Override
    public PartialRowUpdateResult addRowsAllowPartialSuccess(long sheetId, List<Row> rows) throws SmartsheetException {
        return this.doPartialRowOperation(sheetId, rows, null, null, HttpMethod.POST);
    }

    @Override
    public PartialRowUpdateResult addRowsAllowPartialSuccess(long sheetId, List<Row> rows, EnumSet<RowInclusion> includes, EnumSet<ObjectExclusion> excludes) throws SmartsheetException {
        return this.doPartialRowOperation(sheetId, rows, includes, excludes, HttpMethod.POST);
    }

    @Override
    public Row getRow(long sheetId, long rowId, EnumSet<RowInclusion> includes, EnumSet<ObjectExclusion> excludes) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/rows/" + rowId;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, Row.class);
    }

    @Override
    @Deprecated
    public void deleteRow(long sheetId, long rowId) throws SmartsheetException {
        this.deleteResource("sheets/" + sheetId + "/rows/" + rowId, Row.class);
    }

    @Override
    public List<Long> deleteRows(long sheetId, Set<Long> rowIds, boolean ignoreRowsNotFound) throws SmartsheetException {
        Util.throwIfNull(rowIds);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String path = "sheets/" + sheetId + "/rows/";
        parameters.put("ids", QueryUtil.generateCommaSeparatedList(rowIds));
        parameters.put("ignoreRowsNotFound", ignoreRowsNotFound);
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.deleteListResources(path, Long.class);
    }

    @Override
    @Deprecated
    public void sendRow(long sheetId, long rowId, RowEmail email) throws SmartsheetException {
        this.createResource("sheets/" + sheetId + "/rows/" + rowId + "/emails", RowEmail.class, email);
    }

    @Override
    public void sendRows(long sheetId, MultiRowEmail email) throws SmartsheetException {
        this.createResource("sheets/" + sheetId + "/rows/emails", MultiRowEmail.class, email);
    }

    @Override
    public List<Row> updateRows(long sheetId, List<Row> rows) throws SmartsheetException {
        return this.updateRows(sheetId, rows, null, null);
    }

    @Override
    public List<Row> updateRows(long sheetId, List<Row> rows, EnumSet<RowInclusion> includes, EnumSet<ObjectExclusion> excludes) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/rows";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.putAndReceiveList(path, rows, Row.class);
    }

    @Override
    public PartialRowUpdateResult updateRowsAllowPartialSuccess(long sheetId, List<Row> rows) throws SmartsheetException {
        return this.doPartialRowOperation(sheetId, rows, null, null, HttpMethod.PUT);
    }

    @Override
    public PartialRowUpdateResult updateRowsAllowPartialSuccess(long sheetId, List<Row> rows, EnumSet<RowInclusion> includes, EnumSet<ObjectExclusion> excludes) throws SmartsheetException {
        return this.doPartialRowOperation(sheetId, rows, includes, excludes, HttpMethod.PUT);
    }

    private PartialRowUpdateResult doPartialRowOperation(long sheetId, List<Row> rows, EnumSet<RowInclusion> includes, EnumSet<ObjectExclusion> excludes, HttpMethod method) throws SmartsheetException {
        Util.throwIfNull(rows, (Object)method);
        if (method != HttpMethod.POST && method != HttpMethod.PUT) {
            throw new IllegalArgumentException();
        }
        Object path = "sheets/" + sheetId + "/rows";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("allowPartialSuccess", "true");
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = QueryUtil.generateUrl((String)path, parameters);
        HttpRequest request = this.createHttpRequest(this.smartsheet.getBaseURI().resolve((String)path), method);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.smartsheet.getJsonSerializer().serialize(rows, baos);
        HttpEntity entity = new HttpEntity();
        entity.setContentType("application/json");
        entity.setContent(new ByteArrayInputStream(baos.toByteArray()));
        entity.setContentLength(baos.size());
        request.setEntity(entity);
        HttpResponse response = this.smartsheet.getHttpClient().request(request);
        PartialRowUpdateResult result = null;
        switch (response.getStatusCode()) {
            case 200: {
                BulkItemResult<Row> bulkItemResult = this.smartsheet.getJsonSerializer().deserializeBulkItemResult(Row.class, response.getEntity().getContent());
                result = new PartialRowUpdateResult();
                result.setResult((List)bulkItemResult.getResult());
                result.setResultCode(bulkItemResult.getResultCode());
                result.setMessage(bulkItemResult.getMessage());
                result.setVersion(bulkItemResult.getVersion());
                if (bulkItemResult.getFailedItems() == null) break;
                ArrayList<BulkRowFailedItem> failedItems = new ArrayList<BulkRowFailedItem>();
                for (BulkItemFailure bulkItemFailure : bulkItemResult.getFailedItems()) {
                    BulkRowFailedItem bulkRowFailedItem = new BulkRowFailedItem();
                    bulkRowFailedItem.setError(bulkItemFailure.getError());
                    bulkRowFailedItem.setIndex(bulkItemFailure.getIndex());
                    bulkRowFailedItem.setRowId(bulkItemFailure.getRowId());
                    failedItems.add(bulkRowFailedItem);
                }
                result.setFailedItems(failedItems);
                break;
            }
            default: {
                this.handleError(response);
            }
        }
        this.smartsheet.getHttpClient().releaseConnection();
        return result;
    }

    @Override
    public CopyOrMoveRowResult moveRows(Long sheetId, EnumSet<RowMoveInclusion> includes, Boolean ignoreRowsNotFound, CopyOrMoveRowDirective moveParameters) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/rows/move";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        if (ignoreRowsNotFound != null) {
            parameters.put("ignoreRowsNotFound", ignoreRowsNotFound.toString());
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.postAndReceiveRowObject(path, moveParameters);
    }

    @Override
    public CopyOrMoveRowResult copyRows(Long sheetId, EnumSet<RowCopyInclusion> includes, Boolean ignoreRowsNotFound, CopyOrMoveRowDirective copyParameters) throws SmartsheetException {
        String path = "sheets/" + sheetId + "/rows/copy";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        if (ignoreRowsNotFound != null) {
            parameters.put("ignoreRowsNotFound", ignoreRowsNotFound.toString());
        }
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.postAndReceiveRowObject(path, copyParameters);
    }

    @Deprecated
    public List<Cell> updateCells(long rowId, List<Cell> cells) throws SmartsheetException {
        return this.putAndReceiveList("row/" + rowId + "/cells", cells, Cell.class);
    }

    @Override
    public RowAttachmentResources attachmentResources() {
        return this.attachments;
    }

    @Override
    public RowDiscussionResources discussionResources() {
        return this.discussions;
    }

    @Override
    public RowColumnResources cellResources() {
        return this.columns;
    }
}

