/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal.http;

import com.smartsheet.api.internal.http.HttpEntity;
import com.smartsheet.api.internal.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.http.entity.ContentType;
import org.slf4j.LoggerFactory;

public class HttpEntitySnapshot
extends HttpEntity {
    private static final String JSON_MIME_TYPE = ContentType.APPLICATION_JSON.getMimeType();
    private static final int MAX_SNAPSHOT_SIZE = 10240;
    private byte[] contentArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpEntitySnapshot(HttpEntity original) throws IOException {
        String contentType = original.getContentType();
        InputStream contentStream = original.getContent();
        long contentLength = original.getContentLength();
        super.setContentLength(contentLength);
        super.setContentType(contentType);
        if (contentType != null && contentType.startsWith(JSON_MIME_TYPE)) {
            boolean sourceSupportsMark = contentStream.markSupported();
            if (sourceSupportsMark) {
                this.contentArray = new byte[10240];
                contentStream.mark(10241);
                int bytesRead = contentStream.read(this.contentArray, 0, 10240);
                contentStream.reset();
                if (bytesRead < 10240) {
                    this.contentArray = Arrays.copyOf(this.contentArray, bytesRead);
                }
            } else {
                byte[] fullContentArray;
                try {
                    fullContentArray = StreamUtil.readBytesFromStream(contentStream, 0x100000);
                }
                finally {
                    contentStream.close();
                }
                original.setContent(new ByteArrayInputStream(fullContentArray));
                this.contentArray = Arrays.copyOf(fullContentArray, Math.min(10240, fullContentArray.length));
                if (contentLength != -1L && (long)fullContentArray.length != contentLength) {
                    LoggerFactory.getLogger(HttpEntitySnapshot.class).info("actual content-length {} doesn't match declared content-length {}", (Object)fullContentArray.length, (Object)contentLength);
                }
            }
        } else {
            this.contentArray = String.format("**contentType '%s' not logged**", contentType).getBytes();
        }
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.contentArray);
    }

    @Override
    public void setContentLength(long contentLength) {
        throw new UnsupportedOperationException("this class doesn't support having its content length changed");
    }

    @Override
    public void setContentType(String contentType) {
        throw new UnsupportedOperationException("this class doesn't support having its content type changed");
    }

    @Override
    public void setContent(InputStream content) {
        throw new UnsupportedOperationException("this class doesn't support having its content stream changed");
    }

    public byte[] getContentArray() {
        return this.contentArray;
    }
}

