package com.smartsheet.api.models;
/*
 * #[license]
 * Smartsheet SDK for Java
 * %%
 * Copyright (C) 2023 Smartsheet
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * %[license]
 */

import java.util.List;

public class WebhookSubscope {
    private List<Long> columnIds;

    /**
     * Get the array of columnIds if you want to limit the subscription to a subscope.
     *
     * @return
     */
    public List<Long> getColumnIds() {
        return columnIds;
    }

    /**
     * Set the array of columnIds if you want to limit the subscription to a subscope.
     *
     * @param columnIds
     */
    public WebhookSubscope setColumnIds(List<Long> columnIds) {
        this.columnIds = columnIds;
        return this;
    }
}
