/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.DiscussionCommentResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.Util;
import com.smartsheet.api.models.Comment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DiscussionCommentResourcesImpl
extends AbstractResources
implements DiscussionCommentResources {
    private static final String SHEETS_PATH = "sheets/";

    public DiscussionCommentResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public Comment addComment(long sheetId, long discussionId, Comment comment) throws SmartsheetException {
        return this.createResource(SHEETS_PATH + sheetId + "/discussions/" + discussionId + "/comments", Comment.class, comment);
    }

    @Override
    public Comment addCommentWithAttachment(long sheetId, long discussionId, Comment comment, File file, String contentType) throws SmartsheetException, IOException {
        String path = SHEETS_PATH + sheetId + "/discussions/" + discussionId + "/comments";
        Util.throwIfNull(sheetId, comment, file, contentType);
        return this.addCommentWithAttachment(path, comment, new FileInputStream(file), contentType, file.getName());
    }

    private Comment addCommentWithAttachment(String path, Comment comment, InputStream inputStream, String contentType, String attachmentName) throws SmartsheetException {
        return this.createResourceWithAttachment(path, Comment.class, comment, "comment", inputStream, contentType, attachmentName);
    }

    @Override
    public Comment updateComment(long sheetId, Comment comment) throws SmartsheetException {
        return this.updateResource(SHEETS_PATH + sheetId + "/comments/" + comment.getId(), Comment.class, comment);
    }
}

