/*
 * Decompiled with CFR 0.152.
 */
package com.smartsheet.api.internal;

import com.smartsheet.api.FolderResources;
import com.smartsheet.api.SmartsheetException;
import com.smartsheet.api.internal.AbstractResources;
import com.smartsheet.api.internal.SmartsheetImpl;
import com.smartsheet.api.internal.util.QueryUtil;
import com.smartsheet.api.models.ContainerDestination;
import com.smartsheet.api.models.Folder;
import com.smartsheet.api.models.PagedResult;
import com.smartsheet.api.models.PaginationParameters;
import com.smartsheet.api.models.enums.CopyExclusion;
import com.smartsheet.api.models.enums.FolderCopyInclusion;
import com.smartsheet.api.models.enums.FolderRemapExclusion;
import com.smartsheet.api.models.enums.SourceInclusion;
import java.util.EnumSet;
import java.util.HashMap;

public class FolderResourcesImpl
extends AbstractResources
implements FolderResources {
    private static final String FOLDERS_PATH = "folders/";

    public FolderResourcesImpl(SmartsheetImpl smartsheet) {
        super(smartsheet);
    }

    @Override
    public Folder getFolder(long folderId, EnumSet<SourceInclusion> includes) throws SmartsheetException {
        String path = FOLDERS_PATH + folderId;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.getResource(path, Folder.class);
    }

    @Override
    public Folder updateFolder(Folder folder) throws SmartsheetException {
        return this.updateResource(FOLDERS_PATH + folder.getId(), Folder.class, folder);
    }

    @Override
    public void deleteFolder(long folderId) throws SmartsheetException {
        this.deleteResource(FOLDERS_PATH + folderId, Folder.class);
    }

    @Override
    public PagedResult<Folder> listFolders(long parentFolderId, PaginationParameters parameters) throws SmartsheetException {
        String path = FOLDERS_PATH + parentFolderId + "/folders";
        if (parameters != null) {
            path = path + parameters.toQueryString();
        }
        return this.listResourcesWithWrapper(path, Folder.class);
    }

    @Override
    public Folder createFolder(long parentFolderId, Folder folder) throws SmartsheetException {
        return this.createResource(FOLDERS_PATH + parentFolderId + "/folders", Folder.class, folder);
    }

    @Override
    public Folder copyFolder(long folderId, ContainerDestination containerDestination, EnumSet<FolderCopyInclusion> includes, EnumSet<FolderRemapExclusion> skipRemap) throws SmartsheetException {
        return this.copyFolder(folderId, containerDestination, includes, skipRemap, null);
    }

    @Override
    public Folder copyFolder(long folderId, ContainerDestination containerDestination, EnumSet<FolderCopyInclusion> includes, EnumSet<FolderRemapExclusion> skipRemap, EnumSet<CopyExclusion> excludes) throws SmartsheetException {
        String path = FOLDERS_PATH + folderId + "/copy";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("include", QueryUtil.generateCommaSeparatedList(includes));
        parameters.put("skipRemap", QueryUtil.generateCommaSeparatedList(skipRemap));
        parameters.put("exclude", QueryUtil.generateCommaSeparatedList(excludes));
        path = path + QueryUtil.generateUrl(null, parameters);
        return this.createResource(path, Folder.class, containerDestination);
    }

    @Override
    public Folder moveFolder(long folderId, ContainerDestination containerDestination) throws SmartsheetException {
        String path = FOLDERS_PATH + folderId + "/move";
        return this.createResource(path, Folder.class, containerDestination);
    }
}

