/*
 * Decompiled with CFR 0.152.
 */
package com.smattme;

import java.io.File;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmailService {
    private String host = "";
    private int port = 0;
    private String fromAdd = "";
    private String toAdd = "";
    private String username = "";
    private String password = "";
    private String subject = "";
    private String msg = "";
    private File[] attachments;
    private Logger logger = LoggerFactory.getLogger(EmailService.class);
    private final String LOG_PREFIX = "java-mysql-exporter";

    private EmailService() {
    }

    static EmailService builder() {
        return new EmailService();
    }

    EmailService setHost(String host) {
        this.host = host;
        return this;
    }

    EmailService setPort(int port) {
        this.port = port;
        return this;
    }

    EmailService setFromAddress(String fromAdd) {
        this.fromAdd = fromAdd;
        return this;
    }

    EmailService setToAddress(String toAdd) {
        this.toAdd = toAdd;
        return this;
    }

    EmailService setUsername(String username) {
        this.username = username;
        return this;
    }

    EmailService setPassword(String password) {
        this.password = password;
        return this;
    }

    EmailService setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    EmailService setMessage(String message) {
        this.msg = message;
        return this;
    }

    EmailService setAttachments(File[] files) {
        this.attachments = files;
        return this;
    }

    private boolean isPropertiesSet() {
        return !this.host.isEmpty() && this.port > 0 && !this.username.isEmpty() && !this.password.isEmpty() && !this.toAdd.isEmpty() && !this.fromAdd.isEmpty() && !this.subject.isEmpty() && !this.msg.isEmpty() && this.attachments != null && this.attachments.length > 0;
    }

    boolean sendMail() {
        if (!this.isPropertiesSet()) {
            this.logger.debug("java-mysql-exporter: Required Mail Properties are not set. Attachments will not be sent");
            return false;
        }
        Properties prop = new Properties();
        prop.put("mail.smtp.auth", (Object)true);
        prop.put("mail.smtp.starttls.enable", "true");
        prop.put("mail.smtp.host", this.host);
        prop.put("mail.smtp.port", (Object)this.port);
        prop.put("mail.smtp.ssl.trust", this.host);
        this.logger.debug("java-mysql-exporter: Mail properties set");
        Session session = Session.getInstance((Properties)prop, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailService.this.username, EmailService.this.password);
            }
        });
        this.logger.debug("java-mysql-exporter: Mail Session Created");
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.fromAdd));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.toAdd));
            message.setSubject(this.subject);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)this.msg, "text/html");
            MimeBodyPart attachmentBodyPart = new MimeBodyPart();
            this.logger.debug("java-mysql-exporter: " + this.attachments.length + " attachments found");
            for (File file : this.attachments) {
                attachmentBodyPart.attachFile(file);
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)mimeBodyPart);
            multipart.addBodyPart((BodyPart)attachmentBodyPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
            this.logger.debug("java-mysql-exporter: MESSAGE SENT SUCCESSFULLY");
            return true;
        }
        catch (Exception e) {
            this.logger.debug("java-mysql-exporter: MESSAGE NOT SENT. " + e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }
}

