/*
 * Decompiled with CFR 0.152.
 */
package com.smattme;

import com.smattme.MysqlBaseService;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlImportService {
    private String database;
    private String username;
    private String password;
    private String sqlString;
    private String jdbcConnString;
    private String jdbcDriver;
    private boolean deleteExisting = false;
    private boolean dropExisting = false;
    private List<String> tables;
    private Logger logger = LoggerFactory.getLogger(MysqlImportService.class);

    private MysqlImportService() {
        this.tables = new ArrayList<String>();
    }

    public boolean importDatabase() throws SQLException, ClassNotFoundException {
        Connection connection;
        if (!this.assertValidParams()) {
            this.logger.error("Required Parameters not set or empty \nEnsure database, username, password, sqlString params are configured \nusing their respective setters");
            return false;
        }
        if (this.jdbcConnString == null || this.jdbcConnString.isEmpty()) {
            connection = MysqlBaseService.connect(this.username, this.password, this.database, this.jdbcDriver);
        } else {
            this.database = this.jdbcConnString.substring(this.jdbcConnString.lastIndexOf("/") + 1);
            this.logger.debug("database name extracted from connection string: " + this.database);
            connection = MysqlBaseService.connectWithURL(this.username, this.username, this.jdbcConnString, this.jdbcDriver);
        }
        Statement stmt = connection.createStatement();
        stmt.addBatch("SET FOREIGN_KEY_CHECKS = 0");
        if (this.deleteExisting || this.dropExisting) {
            if (this.deleteExisting) {
                this.logger.debug("deleteExisting flag is set to TRUE! I believe you know what you're doing");
            }
            if (this.dropExisting) {
                this.logger.debug("dropExisting flag is set to TRUE! This will drop any existing table(s) in the database");
            }
            this.tables = MysqlBaseService.getAllTables(this.database, stmt);
            for (String table : this.tables) {
                if (this.deleteExisting && !this.dropExisting) {
                    String delQ = "DELETE FROM `" + this.database + "`.`" + table + "`";
                    this.logger.debug("adding " + delQ + " to batch");
                    stmt.addBatch(delQ);
                }
                if (!this.dropExisting) continue;
                String dropQ = "DROP TABLE `" + this.database + "`.`" + table + "`";
                this.logger.debug("adding " + dropQ + " to batch");
                stmt.addBatch(dropQ);
            }
        }
        while (this.sqlString.contains("-- start")) {
            int startIndex = this.sqlString.indexOf("-- start");
            int endIndex = this.sqlString.indexOf("-- end");
            String executable = this.sqlString.substring(startIndex, endIndex);
            this.logger.debug("adding extracted executable SQL chunk to batch : \n" + executable);
            stmt.addBatch(executable);
            this.sqlString = this.sqlString.substring(endIndex + 1);
        }
        stmt.addBatch("SET FOREIGN_KEY_CHECKS = 1");
        long[] result = stmt.executeLargeBatch();
        String[] resultString = new String[]{""};
        Arrays.stream(result).forEach(i -> {
            resultString[0] = resultString[0].concat(i + " ");
        });
        this.logger.debug(result.length + " queries were executed in batch for provided SQL String with the following result : \n" + resultString[0]);
        stmt.close();
        connection.close();
        return true;
    }

    private boolean assertValidParams() {
        return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty() && this.sqlString != null && !this.sqlString.isEmpty() && (this.database != null && !this.database.isEmpty() || this.jdbcConnString != null && !this.jdbcConnString.isEmpty());
    }

    public static MysqlImportService builder() {
        return new MysqlImportService();
    }

    public MysqlImportService setDatabase(String database) {
        this.database = database;
        return this;
    }

    public MysqlImportService setUsername(String username) {
        this.username = username;
        return this;
    }

    public MysqlImportService setPassword(String password) {
        this.password = password;
        return this;
    }

    public MysqlImportService setSqlString(String sqlString) {
        this.sqlString = sqlString;
        return this;
    }

    public MysqlImportService setDeleteExisting(boolean deleteExisting) {
        this.deleteExisting = deleteExisting;
        return this;
    }

    public MysqlImportService setDropExisting(boolean dropExistingTable) {
        this.dropExisting = dropExistingTable;
        return this;
    }

    public MysqlImportService setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public MysqlImportService setJdbcConnString(String jdbcConnString) {
        this.jdbcConnString = jdbcConnString;
        return this;
    }
}

