/*
 * Decompiled with CFR 0.152.
 */
package com.smattme;

import com.smattme.TablesResponse;
import com.smattme.exceptions.MysqlBackup4JException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlBaseService {
    private static Logger logger = LoggerFactory.getLogger(MysqlBaseService.class);
    static final String SQL_START_PATTERN = "-- start";
    static final String SQL_END_PATTERN = "-- end";

    @Deprecated
    static Connection connect(String username, String password, String database, String driverName) throws ClassNotFoundException, SQLException {
        String url = "jdbc:mysql://localhost:3306/" + database + "?useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC&useSSL=false";
        String driver = Objects.isNull(driverName) || driverName.isEmpty() ? "com.mysql.cj.jdbc.Driver" : driverName;
        return MysqlBaseService.doConnect(driver, url, username, password);
    }

    public static Connection connect(String username, String password, String host, String port, String database, String driverName) throws ClassNotFoundException, SQLException {
        String url = String.format("jdbc:mysql://%s:%s/%s", host, port, database);
        url = url + "?useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC&useSSL=false";
        String driver = Objects.isNull(driverName) || driverName.isEmpty() ? "com.mysql.cj.jdbc.Driver" : driverName;
        return MysqlBaseService.doConnect(driver, url, username, password);
    }

    static Connection connectWithURL(String username, String password, String jdbcURL, String driverName) throws ClassNotFoundException, SQLException {
        String driver = Objects.isNull(driverName) || driverName.isEmpty() ? "com.mysql.cj.jdbc.Driver" : driverName;
        return MysqlBaseService.doConnect(driver, jdbcURL, username, password);
    }

    private static Connection doConnect(String driver, String url, String username, String password) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        Connection connection = DriverManager.getConnection(url, username, password);
        logger.debug("DB Connected Successfully");
        return connection;
    }

    static TablesResponse getAllTablesAndViews(String database, Statement stmt) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> views = new ArrayList<String>();
        ResultSet rs = stmt.executeQuery("SHOW TABLE STATUS FROM `" + database + "`;");
        while (rs.next()) {
            String comment = rs.getString("Comment");
            if ("VIEW".equals(comment)) {
                views.add(rs.getString("Name"));
                continue;
            }
            tables.add(rs.getString("Name"));
        }
        return new TablesResponse(tables, views);
    }

    static String getEmptyTableSQL(String database, String table) {
        String safeDeleteSQL = "SELECT IF( \n(SELECT COUNT(1) as table_exists FROM information_schema.tables \nWHERE table_schema='" + database + "' AND table_name='" + table + "') > 1, \n'DELETE FROM " + table + "', \n'SELECT 1') INTO @DeleteSQL; \nPREPARE stmt FROM @DeleteSQL; \nEXECUTE stmt; DEALLOCATE PREPARE stmt; \n";
        return "\n-- start\n" + safeDeleteSQL + "\n\n" + SQL_END_PATTERN + "\n";
    }

    public static String extractDatabaseNameFromJDBCUrl(String jdbcURL) {
        if (jdbcURL == null || jdbcURL.isEmpty()) {
            throw new MysqlBackup4JException("Null or Empty JDBC URL supplied: " + jdbcURL);
        }
        String jdbcURLWithoutParams = jdbcURL.contains("?") ? jdbcURL.substring(0, jdbcURL.indexOf("?")) : jdbcURL;
        return jdbcURLWithoutParams.substring(jdbcURLWithoutParams.lastIndexOf("/") + 1);
    }
}

