/*
 * Decompiled with CFR 0.152.
 */
package com.smattme;

import com.smattme.EmailService;
import com.smattme.MysqlBaseService;
import com.smattme.TablesResponse;
import com.smattme.exceptions.MysqlBackup4JException;
import com.smattme.helpers.MysqlExportServiceHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ZipUtil;

public class MysqlExportService {
    private Statement stmt;
    private String database;
    private String generatedSql = "";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String LOG_PREFIX = "mysql-backup4j-export";
    private String dirName = "mysql-backup4j-export-temp";
    private String sqlFileName = "";
    private String zipFileName = "";
    private Properties properties;
    private File generatedZipFile;
    public static final String EMAIL_HOST = "EMAIL_HOST";
    public static final String EMAIL_PORT = "EMAIL_PORT";
    public static final String EMAIL_USERNAME = "EMAIL_USERNAME";
    public static final String EMAIL_PASSWORD = "EMAIL_PASSWORD";
    public static final String EMAIL_SUBJECT = "EMAIL_SUBJECT";
    public static final String EMAIL_MESSAGE = "EMAIL_MESSAGE";
    public static final String EMAIL_FROM = "EMAIL_FROM";
    public static final String EMAIL_TO = "EMAIL_TO";
    public static final String EMAIL_SSL_PROTOCOLS = "EMAIL_SSL_PROTOCOLS";
    public static final String EMAIL_START_TLS_ENABLED = "EMAIL_START_TLS_ENABLED";
    public static final String EMAIL_SMTP_AUTH_ENABLED = "EMAIL_SMTP_AUTH_ENABLED";
    public static final String DB_NAME = "DB_NAME";
    public static final String DB_USERNAME = "DB_USERNAME";
    public static final String DB_PASSWORD = "DB_PASSWORD";
    public static final String DB_HOST = "DB_HOST";
    public static final String DB_PORT = "DB_PORT";
    public static final String PRESERVE_GENERATED_ZIP = "PRESERVE_GENERATED_ZIP";
    public static final String PRESERVE_GENERATED_SQL_FILE = "PRESERVE_GENERATED_SQL_FILE";
    public static final String TEMP_DIR = "TEMP_DIR";
    public static final String ADD_IF_NOT_EXISTS = "ADD_IF_NOT_EXISTS";
    public static final String DROP_TABLES = "DROP_TABLES";
    public static final String DELETE_EXISTING_DATA = "DELETE_EXISTING_DATA";
    public static final String JDBC_CONNECTION_STRING = "JDBC_CONNECTION_STRING";
    public static final String JDBC_DRIVER_NAME = "JDBC_DRIVER_NAME";
    public static final String SQL_FILE_NAME = "SQL_FILE_NAME";

    public MysqlExportService(Properties properties) {
        this.properties = properties;
    }

    private boolean isValidateProperties() {
        return this.properties != null && this.properties.containsKey(DB_USERNAME) && (this.properties.containsKey(DB_NAME) || this.properties.containsKey(JDBC_CONNECTION_STRING));
    }

    private boolean isEmailPropertiesSet() {
        return this.properties != null && this.properties.containsKey(EMAIL_HOST) && this.properties.containsKey(EMAIL_PORT) && this.properties.containsKey(EMAIL_USERNAME) && this.properties.containsKey(EMAIL_PASSWORD) && this.properties.containsKey(EMAIL_FROM) && this.properties.containsKey(EMAIL_TO);
    }

    private boolean isSqlFileNamePropertySet() {
        return this.properties != null && this.properties.containsKey(SQL_FILE_NAME);
    }

    private String getTableInsertStatement(String table) throws SQLException {
        StringBuilder sql = new StringBuilder();
        boolean addIfNotExists = Boolean.parseBoolean(this.properties.containsKey(ADD_IF_NOT_EXISTS) ? this.properties.getProperty(ADD_IF_NOT_EXISTS, "true") : "true");
        if (table != null && !table.isEmpty()) {
            ResultSet rs = this.stmt.executeQuery("SHOW CREATE TABLE `" + table + "`;");
            while (rs.next()) {
                String qtbl = rs.getString(1);
                String query = rs.getString(2);
                sql.append("\n\n--");
                sql.append("\n").append("-- start").append("  table dump : ").append(qtbl);
                sql.append("\n--\n\n");
                if (addIfNotExists) {
                    query = query.trim().replace("CREATE TABLE", "CREATE TABLE IF NOT EXISTS");
                }
                sql.append(query).append(";\n\n");
            }
            sql.append("\n\n--");
            sql.append("\n").append("-- end").append("  table dump : ").append(table);
            sql.append("\n--\n\n");
        }
        return sql.toString();
    }

    private String getCreateViewStatement(String view) throws SQLException {
        StringBuilder sql = new StringBuilder();
        if (view != null && !view.isEmpty()) {
            ResultSet rs = this.stmt.executeQuery("SHOW CREATE VIEW `" + view + "`;");
            while (rs.next()) {
                String viewName = rs.getString(1);
                String viewQuery = rs.getString(2);
                sql.append("\n\n--");
                sql.append("\n").append("-- start").append("  view dump : ").append(view);
                sql.append("\n--\n\n");
                String finalQuery = "CREATE OR REPLACE VIEW `" + viewName + "` " + viewQuery.substring(viewQuery.indexOf("AS")).trim();
                sql.append(finalQuery).append(";\n\n");
            }
            sql.append("\n\n--");
            sql.append("\n").append("-- end").append("  view dump : ").append(view);
            sql.append("\n--\n\n");
        }
        return sql.toString();
    }

    private String getDataInsertStatement(String table) throws SQLException {
        int i;
        StringBuilder sql = new StringBuilder();
        ResultSet rs = this.stmt.executeQuery("SELECT * FROM `" + table + "`;");
        rs.last();
        int rowCount = rs.getRow();
        if (rowCount <= 0) {
            return sql.toString();
        }
        sql.append("\n--").append("\n-- Inserts of ").append(table).append("\n--\n\n");
        sql.append("\n/*!40000 ALTER TABLE `").append(table).append("` DISABLE KEYS */;\n");
        sql.append("\n--\n").append("-- start").append(" table insert : ").append(table).append("\n--\n");
        sql.append("INSERT INTO `").append(table).append("`(");
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (i = 0; i < columnCount; ++i) {
            sql.append("`").append(metaData.getColumnName(i + 1)).append("`, ");
        }
        sql.deleteCharAt(sql.length() - 1).deleteCharAt(sql.length() - 1).append(") VALUES \n");
        rs.beforeFirst();
        while (rs.next()) {
            sql.append("(");
            for (i = 0; i < columnCount; ++i) {
                int columnType = metaData.getColumnType(i + 1);
                int columnIndex = i + 1;
                if (Objects.isNull(rs.getObject(columnIndex))) {
                    sql.append(rs.getObject(columnIndex)).append(", ");
                    continue;
                }
                if (columnType == 4 || columnType == -6 || columnType == -7 || columnType == 5 || columnType == -5) {
                    sql.append(rs.getInt(columnIndex)).append(", ");
                    continue;
                }
                if (columnType == 7 || columnType == 6 || columnType == 8 || columnType == 3 || columnType == 2) {
                    sql.append(rs.getDouble(columnIndex)).append(", ");
                    continue;
                }
                if (columnType == -2 || columnType == 2004 || columnType == -4 || columnType == -3) {
                    sql.append("0x").append(MysqlExportServiceHelper.bytesToHex(rs.getBytes(columnIndex))).append(", ");
                    continue;
                }
                String val = rs.getString(columnIndex);
                val = val.replace("'", "\\'");
                sql.append("'").append(val).append("', ");
            }
            sql.deleteCharAt(sql.length() - 1).deleteCharAt(sql.length() - 1);
            if (rs.isLast()) {
                sql.append(")");
                continue;
            }
            sql.append("),\n");
        }
        sql.append(";");
        sql.append("\n--\n").append("-- end").append(" table insert : ").append(table).append("\n--\n");
        sql.append("\n/*!40000 ALTER TABLE `").append(table).append("` ENABLE KEYS */;\n");
        return sql.toString();
    }

    private String exportToSql() throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("--");
        sql.append("\n-- Generated by mysql-backup4j");
        sql.append("\n-- https://github.com/SeunMatt/mysql-backup4j");
        sql.append("\n-- Date: ").append(new SimpleDateFormat("d-M-Y H:m:s").format(new Date()));
        sql.append("\n--");
        sql.append("\n\n/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;").append("\n/*!40101 SET NAMES utf8 */;").append("\n/*!50503 SET NAMES utf8mb4 */;").append("\n/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;").append("\n/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;");
        TablesResponse allTablesAndViews = MysqlBaseService.getAllTablesAndViews(this.database, this.stmt);
        List<String> tables = allTablesAndViews.getTables();
        for (String s : tables) {
            try {
                sql.append(this.getTableInsertStatement(s.trim()));
                sql.append(this.getDataInsertStatement(s.trim()));
            }
            catch (SQLException e) {
                this.logger.error("Exception occurred while processing table: " + s, (Throwable)e);
            }
        }
        List<String> views = allTablesAndViews.getViews();
        for (String v : views) {
            try {
                sql.append(this.getCreateViewStatement(v.trim()));
            }
            catch (SQLException e) {
                this.logger.error("Exception occurred while processing view: " + v, (Throwable)e);
            }
        }
        sql.append("\n/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;").append("\n/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;").append("\n/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;");
        this.generatedSql = sql.toString();
        return sql.toString();
    }

    public void export() throws IOException, SQLException, ClassNotFoundException {
        boolean res;
        boolean res2;
        Connection connection;
        if (!this.isValidateProperties()) {
            String message = "Invalid config properties: The config properties is missing important parameters: DB_NAME, DB_USERNAME and DB_PASSWORD";
            this.logger.error(message);
            throw new MysqlBackup4JException(message);
        }
        this.database = this.properties.getProperty(DB_NAME);
        String jdbcURL = this.properties.getProperty(JDBC_CONNECTION_STRING, "");
        String driverName = this.properties.getProperty(JDBC_DRIVER_NAME, "");
        if (jdbcURL == null || jdbcURL.isEmpty()) {
            connection = MysqlBaseService.connect(this.properties.getProperty(DB_USERNAME), this.properties.getProperty(DB_PASSWORD), this.properties.getProperty(DB_HOST, "localhost"), this.properties.getProperty(DB_PORT, "3306"), this.database, driverName);
        } else {
            if (this.database == null || this.database.isEmpty()) {
                this.database = MysqlBaseService.extractDatabaseNameFromJDBCUrl(jdbcURL);
            }
            connection = MysqlBaseService.connectWithURL(this.properties.getProperty(DB_USERNAME), this.properties.getProperty(DB_PASSWORD), jdbcURL, driverName);
        }
        this.stmt = connection.createStatement(1004, 1007);
        String sql = this.exportToSql();
        this.stmt.close();
        connection.close();
        this.dirName = this.properties.getProperty(TEMP_DIR, this.dirName);
        File file = new File(this.dirName);
        if (!file.exists() && !(res2 = file.mkdir())) {
            throw new IOException("mysql-backup4j-export: Unable to create temp dir: " + file.getAbsolutePath());
        }
        File sqlFolder = new File(this.dirName + "/sql");
        if (!sqlFolder.exists() && !(res = sqlFolder.mkdir())) {
            throw new IOException("mysql-backup4j-export: Unable to create temp dir: " + file.getAbsolutePath());
        }
        this.sqlFileName = this.getSqlFilename();
        FileOutputStream outputStream = new FileOutputStream(sqlFolder + "/" + this.sqlFileName);
        outputStream.write(sql.getBytes());
        outputStream.close();
        this.zipFileName = this.dirName + "/" + this.sqlFileName.replace(".sql", ".zip");
        this.generatedZipFile = new File(this.zipFileName);
        ZipUtil.pack((File)sqlFolder, (File)this.generatedZipFile);
        if (this.isEmailPropertiesSet()) {
            boolean emailSendingRes = EmailService.builder().setHost(this.properties.getProperty(EMAIL_HOST)).setPort(Integer.parseInt(this.properties.getProperty(EMAIL_PORT))).setToAddress(this.properties.getProperty(EMAIL_TO)).setFromAddress(this.properties.getProperty(EMAIL_FROM)).setUsername(this.properties.getProperty(EMAIL_USERNAME)).setPassword(this.properties.getProperty(EMAIL_PASSWORD)).setSslProtocols(this.properties.getProperty(EMAIL_SSL_PROTOCOLS, "TLSv1.2")).setStartTlsEnabled(this.properties.getProperty(EMAIL_START_TLS_ENABLED, "true")).setSmtpAuthEnabled(Boolean.parseBoolean(this.properties.getProperty(EMAIL_SMTP_AUTH_ENABLED, "true"))).setSubject(this.properties.getProperty(EMAIL_SUBJECT, this.sqlFileName.replace(".sql", "").toUpperCase())).setMessage(this.properties.getProperty(EMAIL_MESSAGE, "Please find attached database backup of " + this.database)).setAttachments(new File[]{new File(this.zipFileName)}).sendMail();
            if (emailSendingRes) {
                this.logger.debug("mysql-backup4j-export: Zip File Sent as Attachment to Email Address Successfully");
            } else {
                this.logger.error("mysql-backup4j-export: Unable to send zipped file as attachment to email. See log debug for more info");
            }
        }
        this.clearTempFiles();
    }

    public void clearTempFiles() {
        boolean res;
        if (!Boolean.parseBoolean(this.properties.getProperty(PRESERVE_GENERATED_SQL_FILE, Boolean.FALSE.toString()))) {
            File sqlFile = new File(this.dirName + "/sql/" + this.sqlFileName);
            if (sqlFile.exists()) {
                boolean res2 = sqlFile.delete();
                this.logger.debug("mysql-backup4j-export: " + sqlFile.getAbsolutePath() + " deleted successfully? " + (res2 ? " TRUE " : " FALSE "));
            } else {
                this.logger.debug("mysql-backup4j-export: " + sqlFile.getAbsolutePath() + " DOES NOT EXIST while clearing Temp Files");
            }
            File sqlFolder = new File(this.dirName + "/sql");
            if (sqlFolder.exists()) {
                res = sqlFolder.delete();
                this.logger.debug("mysql-backup4j-export: " + sqlFolder.getAbsolutePath() + " deleted successfully? " + (res ? " TRUE " : " FALSE "));
            } else {
                this.logger.debug("mysql-backup4j-export: " + sqlFolder.getAbsolutePath() + " DOES NOT EXIST while clearing Temp Files");
            }
        }
        if (!Boolean.parseBoolean(this.properties.getProperty(PRESERVE_GENERATED_ZIP, Boolean.FALSE.toString()))) {
            File zipFile = new File(this.zipFileName);
            if (zipFile.exists()) {
                boolean res3 = zipFile.delete();
                this.logger.debug("mysql-backup4j-export: " + zipFile.getAbsolutePath() + " deleted successfully? " + (res3 ? " TRUE " : " FALSE "));
            } else {
                this.logger.debug("mysql-backup4j-export: " + zipFile.getAbsolutePath() + " DOES NOT EXIST while clearing Temp Files");
            }
            File folder = new File(this.dirName);
            if (folder.exists()) {
                res = folder.delete();
                this.logger.debug("mysql-backup4j-export: " + folder.getAbsolutePath() + " deleted successfully? " + (res ? " TRUE " : " FALSE "));
            } else {
                this.logger.debug("mysql-backup4j-export: " + folder.getAbsolutePath() + " DOES NOT EXIST while clearing Temp Files");
            }
        }
        this.logger.debug("mysql-backup4j-export: generated temp files cleared successfully");
    }

    public String getSqlFilename() {
        return this.isSqlFileNamePropertySet() ? this.properties.getProperty(SQL_FILE_NAME) + ".sql" : new SimpleDateFormat("d_M_Y_H_mm_ss").format(new Date()) + "_" + this.database + "_database_dump.sql";
    }

    public String getSqlFileName() {
        return this.sqlFileName;
    }

    public String getGeneratedSql() {
        return this.generatedSql;
    }

    public File getGeneratedZipFile() {
        if (this.generatedZipFile != null && this.generatedZipFile.exists()) {
            return this.generatedZipFile;
        }
        return null;
    }
}

