/*
 * Decompiled with CFR 0.152.
 */
package com.smattme;

import com.smattme.MysqlBaseService;
import com.smattme.TablesResponse;
import com.smattme.exceptions.MysqlBackup4JException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlImportService {
    private String database;
    private String username;
    private String host = "localhost";
    private String port = "3306";
    private String password;
    private String sqlString;
    private String jdbcConnString;
    private String jdbcDriver;
    private boolean deleteExisting = false;
    private boolean dropExisting = false;
    private List<String> tables;
    private Logger logger = LoggerFactory.getLogger(MysqlImportService.class);

    private MysqlImportService() {
        this.tables = new ArrayList<String>();
    }

    public boolean importDatabase() throws SQLException, ClassNotFoundException {
        Connection connection;
        if (!this.assertValidParams()) {
            String message = "Required Parameters not set or empty \nEnsure database, username, password, sqlString params are configured \nusing their respective setters";
            this.logger.error(message);
            throw new MysqlBackup4JException(message);
        }
        if (this.jdbcConnString == null || this.jdbcConnString.isEmpty()) {
            connection = MysqlBaseService.connect(this.username, this.password, this.host, this.port, this.database, this.jdbcDriver);
        } else {
            if (this.database == null || this.database.isEmpty()) {
                this.database = MysqlBaseService.extractDatabaseNameFromJDBCUrl(this.jdbcConnString);
                this.logger.debug("database name extracted from connection string: " + this.database);
            }
            connection = MysqlBaseService.connectWithURL(this.username, this.password, this.jdbcConnString, this.jdbcDriver);
        }
        Statement stmt = connection.createStatement();
        if (this.deleteExisting || this.dropExisting) {
            TablesResponse allTablesAndViews = MysqlBaseService.getAllTablesAndViews(this.database, stmt);
            this.tables = allTablesAndViews.getTables();
            this.logger.debug("tables found for deleting/dropping: \n" + this.tables.toString());
            for (String string : this.tables) {
                if (this.deleteExisting && !this.dropExisting) {
                    String delQ = "DELETE FROM `" + string + "`;";
                    this.logger.debug("adding " + delQ + " to batch");
                    stmt.addBatch(delQ);
                }
                if (!this.dropExisting) continue;
                String dropQ = "DROP TABLE IF EXISTS `" + string + "`";
                this.logger.debug("adding " + dropQ + " to batch");
                stmt.addBatch(dropQ);
            }
            List<String> views = allTablesAndViews.getViews();
            for (String view : views) {
                if (!this.dropExisting) continue;
                String dropQ = "DROP VIEW IF EXISTS `" + view + "`";
                this.logger.debug("adding " + dropQ + " to batch");
                stmt.addBatch(dropQ);
            }
        }
        stmt.addBatch("SET FOREIGN_KEY_CHECKS = 0");
        while (this.sqlString.contains("-- start")) {
            int startIndex = this.sqlString.indexOf("-- start");
            int endIndex = this.sqlString.indexOf("-- end");
            String string = this.sqlString.substring(startIndex, endIndex).trim();
            this.logger.debug("adding extracted executable SQL chunk to batch : \n" + string);
            stmt.addBatch(string);
            this.sqlString = this.sqlString.substring(endIndex + 1);
        }
        stmt.addBatch("SET FOREIGN_KEY_CHECKS = 1");
        long[] result = stmt.executeLargeBatch();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(result.length + " queries were executed in batches for provided SQL String with the following result : \n" + Arrays.toString(result));
        }
        stmt.close();
        connection.close();
        return true;
    }

    private boolean assertValidParams() {
        return this.username != null && !this.username.isEmpty() && this.sqlString != null && !this.sqlString.isEmpty() && (this.database != null && !this.database.isEmpty() || this.jdbcConnString != null && !this.jdbcConnString.isEmpty());
    }

    public static MysqlImportService builder() {
        return new MysqlImportService();
    }

    public MysqlImportService setDatabase(String database) {
        this.database = database;
        return this;
    }

    public MysqlImportService setUsername(String username) {
        this.username = username;
        return this;
    }

    public MysqlImportService setPassword(String password) {
        this.password = password;
        return this;
    }

    public MysqlImportService setSqlString(String sqlString) {
        this.sqlString = sqlString;
        return this;
    }

    public MysqlImportService setDeleteExisting(boolean deleteExisting) {
        this.deleteExisting = deleteExisting;
        return this;
    }

    public MysqlImportService setDropExisting(boolean dropExistingTable) {
        this.dropExisting = dropExistingTable;
        return this;
    }

    public MysqlImportService setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public MysqlImportService setJdbcConnString(String jdbcConnString) {
        this.jdbcConnString = jdbcConnString;
        return this;
    }

    public MysqlImportService setHost(String host) {
        this.host = host;
        return this;
    }

    public MysqlImportService setPort(String port) {
        this.port = port;
        return this;
    }
}

