/*
 * Snap Conversions API V3
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.snap.business.sdk.v3.api;


import com.google.gson.reflect.TypeToken;
import com.snap.business.sdk.v3.ApiCallback;
import com.snap.business.sdk.v3.ApiClient;
import com.snap.business.sdk.v3.ApiException;
import com.snap.business.sdk.v3.ApiResponse;
import com.snap.business.sdk.v3.Configuration;
import com.snap.business.sdk.v3.Pair;
import com.snap.business.sdk.v3.model.EventResponse;
import com.snap.business.sdk.v3.model.GetLogsResponse;
import com.snap.business.sdk.v3.model.GetStatsResponse;
import com.snap.business.sdk.v3.model.SendEventRequest;
import com.snap.business.sdk.v3.model.SendValidationEventRequest;
import com.snap.business.sdk.v3.model.ValidateResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for getValidationLogs
     *
     * @param assetId The asset ID for which log data is being requested. (required)
     * @param accessToken Access token for authentication. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getValidationLogsCall(
            String assetId, String accessToken, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath =
                "/v3/{asset_id}/events/validate/logs"
                        .replace(
                                "{" + "asset_id" + "}",
                                localVarApiClient.escapeString(assetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accessToken != null) {
            localVarQueryParams.addAll(
                    localVarApiClient.parameterToPair("access_token", accessToken));
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {};
        final String localVarContentType =
                localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(
                basePath,
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarCookieParams,
                localVarFormParams,
                localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getValidationLogsValidateBeforeCall(
            String assetId, String accessToken, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'assetId' is set
        if (assetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'assetId' when calling"
                            + " getValidationLogs(Async)");
        }

        // verify the required parameter 'accessToken' is set
        if (accessToken == null) {
            throw new ApiException(
                    "Missing the required parameter 'accessToken' when calling"
                            + " getValidationLogs(Async)");
        }

        return getValidationLogsCall(assetId, accessToken, _callback);
    }

    /**
     * @param assetId The asset ID for which log data is being requested. (required)
     * @param accessToken Access token for authentication. (required)
     * @return GetLogsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public GetLogsResponse getValidationLogs(String assetId, String accessToken)
            throws ApiException {
        ApiResponse<GetLogsResponse> localVarResp =
                getValidationLogsWithHttpInfo(assetId, accessToken);
        return localVarResp.getData();
    }

    /**
     * @param assetId The asset ID for which log data is being requested. (required)
     * @param accessToken Access token for authentication. (required)
     * @return ApiResponse&lt;GetLogsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<GetLogsResponse> getValidationLogsWithHttpInfo(
            String assetId, String accessToken) throws ApiException {
        okhttp3.Call localVarCall = getValidationLogsValidateBeforeCall(assetId, accessToken, null);
        Type localVarReturnType = new TypeToken<GetLogsResponse>() {}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * (asynchronously)
     *
     * @param assetId The asset ID for which log data is being requested. (required)
     * @param accessToken Access token for authentication. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body
     *     object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getValidationLogsAsync(
            String assetId, String accessToken, final ApiCallback<GetLogsResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall =
                getValidationLogsValidateBeforeCall(assetId, accessToken, _callback);
        Type localVarReturnType = new TypeToken<GetLogsResponse>() {}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getValidationStats
     *
     * @param assetId The asset ID for which stats on test and non-test events are being retrieved.
     *     (required)
     * @param accessToken Access token for authentication. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getValidationStatsCall(
            String assetId, String accessToken, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath =
                "/v3/{asset_id}/events/validate/stats"
                        .replace(
                                "{" + "asset_id" + "}",
                                localVarApiClient.escapeString(assetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accessToken != null) {
            localVarQueryParams.addAll(
                    localVarApiClient.parameterToPair("access_token", accessToken));
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {};
        final String localVarContentType =
                localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(
                basePath,
                localVarPath,
                "GET",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarCookieParams,
                localVarFormParams,
                localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getValidationStatsValidateBeforeCall(
            String assetId, String accessToken, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'assetId' is set
        if (assetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'assetId' when calling"
                            + " getValidationStats(Async)");
        }

        // verify the required parameter 'accessToken' is set
        if (accessToken == null) {
            throw new ApiException(
                    "Missing the required parameter 'accessToken' when calling"
                            + " getValidationStats(Async)");
        }

        return getValidationStatsCall(assetId, accessToken, _callback);
    }

    /**
     * @param assetId The asset ID for which stats on test and non-test events are being retrieved.
     *     (required)
     * @param accessToken Access token for authentication. (required)
     * @return GetStatsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public GetStatsResponse getValidationStats(String assetId, String accessToken)
            throws ApiException {
        ApiResponse<GetStatsResponse> localVarResp =
                getValidationStatsWithHttpInfo(assetId, accessToken);
        return localVarResp.getData();
    }

    /**
     * @param assetId The asset ID for which stats on test and non-test events are being retrieved.
     *     (required)
     * @param accessToken Access token for authentication. (required)
     * @return ApiResponse&lt;GetStatsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<GetStatsResponse> getValidationStatsWithHttpInfo(
            String assetId, String accessToken) throws ApiException {
        okhttp3.Call localVarCall =
                getValidationStatsValidateBeforeCall(assetId, accessToken, null);
        Type localVarReturnType = new TypeToken<GetStatsResponse>() {}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * (asynchronously)
     *
     * @param assetId The asset ID for which stats on test and non-test events are being retrieved.
     *     (required)
     * @param accessToken Access token for authentication. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body
     *     object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call getValidationStatsAsync(
            String assetId, String accessToken, final ApiCallback<GetStatsResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall =
                getValidationStatsValidateBeforeCall(assetId, accessToken, _callback);
        Type localVarReturnType = new TypeToken<GetStatsResponse>() {}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEvent
     *
     * @param assetId The asset ID for which the event data is being sent. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Event data for a specific asset. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call sendEventCall(
            String assetId, String accessToken, SendEventRequest body, final ApiCallback _callback)
            throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath =
                "/v3/{asset_id}/events"
                        .replace(
                                "{" + "asset_id" + "}",
                                localVarApiClient.escapeString(assetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accessToken != null) {
            localVarQueryParams.addAll(
                    localVarApiClient.parameterToPair("access_token", accessToken));
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {"application/json"};
        final String localVarContentType =
                localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(
                basePath,
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarCookieParams,
                localVarFormParams,
                localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEventValidateBeforeCall(
            String assetId, String accessToken, SendEventRequest body, final ApiCallback _callback)
            throws ApiException {
        // verify the required parameter 'assetId' is set
        if (assetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'assetId' when calling sendEvent(Async)");
        }

        // verify the required parameter 'accessToken' is set
        if (accessToken == null) {
            throw new ApiException(
                    "Missing the required parameter 'accessToken' when calling sendEvent(Async)");
        }

        return sendEventCall(assetId, accessToken, body, _callback);
    }

    /**
     * @param assetId The asset ID for which the event data is being sent. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Event data for a specific asset. (optional)
     * @return EventResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public EventResponse sendEvent(String assetId, String accessToken, SendEventRequest body)
            throws ApiException {
        ApiResponse<EventResponse> localVarResp = sendEventWithHttpInfo(assetId, accessToken, body);
        return localVarResp.getData();
    }

    /**
     * @param assetId The asset ID for which the event data is being sent. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Event data for a specific asset. (optional)
     * @return ApiResponse&lt;EventResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<EventResponse> sendEventWithHttpInfo(
            String assetId, String accessToken, SendEventRequest body) throws ApiException {
        okhttp3.Call localVarCall = sendEventValidateBeforeCall(assetId, accessToken, body, null);
        Type localVarReturnType = new TypeToken<EventResponse>() {}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * (asynchronously)
     *
     * @param assetId The asset ID for which the event data is being sent. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Event data for a specific asset. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body
     *     object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call sendEventAsync(
            String assetId,
            String accessToken,
            SendEventRequest body,
            final ApiCallback<EventResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall =
                sendEventValidateBeforeCall(assetId, accessToken, body, _callback);
        Type localVarReturnType = new TypeToken<EventResponse>() {}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendValidationEvent
     *
     * @param assetId The asset ID associated with the event data being validated. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Test event tool data for a specific asset id. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call sendValidationEventCall(
            String assetId,
            String accessToken,
            SendValidationEventRequest body,
            final ApiCallback _callback)
            throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {};

        // Determine Base Path to Use
        if (localCustomBaseUrl != null) {
            basePath = localCustomBaseUrl;
        } else if (localBasePaths.length > 0) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath =
                "/v3/{asset_id}/events/validate"
                        .replace(
                                "{" + "asset_id" + "}",
                                localVarApiClient.escapeString(assetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (accessToken != null) {
            localVarQueryParams.addAll(
                    localVarApiClient.parameterToPair("access_token", accessToken));
        }

        final String[] localVarAccepts = {"application/json"};
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {"application/json"};
        final String localVarContentType =
                localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(
                basePath,
                localVarPath,
                "POST",
                localVarQueryParams,
                localVarCollectionQueryParams,
                localVarPostBody,
                localVarHeaderParams,
                localVarCookieParams,
                localVarFormParams,
                localVarAuthNames,
                _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendValidationEventValidateBeforeCall(
            String assetId,
            String accessToken,
            SendValidationEventRequest body,
            final ApiCallback _callback)
            throws ApiException {
        // verify the required parameter 'assetId' is set
        if (assetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'assetId' when calling"
                            + " sendValidationEvent(Async)");
        }

        // verify the required parameter 'accessToken' is set
        if (accessToken == null) {
            throw new ApiException(
                    "Missing the required parameter 'accessToken' when calling"
                            + " sendValidationEvent(Async)");
        }

        return sendValidationEventCall(assetId, accessToken, body, _callback);
    }

    /**
     * @param assetId The asset ID associated with the event data being validated. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Test event tool data for a specific asset id. (optional)
     * @return ValidateResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public ValidateResponse sendValidationEvent(
            String assetId, String accessToken, SendValidationEventRequest body)
            throws ApiException {
        ApiResponse<ValidateResponse> localVarResp =
                sendValidationEventWithHttpInfo(assetId, accessToken, body);
        return localVarResp.getData();
    }

    /**
     * @param assetId The asset ID associated with the event data being validated. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Test event tool data for a specific asset id. (optional)
     * @return ApiResponse&lt;ValidateResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
     *     response body
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public ApiResponse<ValidateResponse> sendValidationEventWithHttpInfo(
            String assetId, String accessToken, SendValidationEventRequest body)
            throws ApiException {
        okhttp3.Call localVarCall =
                sendValidationEventValidateBeforeCall(assetId, accessToken, body, null);
        Type localVarReturnType = new TypeToken<ValidateResponse>() {}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * (asynchronously)
     *
     * @param assetId The asset ID associated with the event data being validated. (required)
     * @param accessToken Access token for authentication. (required)
     * @param body Test event tool data for a specific asset id. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body
     *     object
     * @http.response.details
     *     <table summary="Response Details" border="1">
     * <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
     * <tr><td> 200 </td><td> successful operation </td><td>  -  </td></tr>
     * <tr><td> 0 </td><td> unsuccessful operation </td><td>  -  </td></tr>
     * </table>
     */
    public okhttp3.Call sendValidationEventAsync(
            String assetId,
            String accessToken,
            SendValidationEventRequest body,
            final ApiCallback<ValidateResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall =
                sendValidationEventValidateBeforeCall(assetId, accessToken, body, _callback);
        Type localVarReturnType = new TypeToken<ValidateResponse>() {}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
