/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DaemonAppender<E>
implements Runnable {
    private static ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    private static final Logger LOG = LoggerFactory.getLogger(DaemonAppender.class);
    private AtomicBoolean start = new AtomicBoolean(false);
    private final BlockingQueue<E> queue;

    DaemonAppender(int maxQueueSize) {
        this.queue = new LinkedBlockingQueue(maxQueueSize);
    }

    protected void execute() {
        if (THREAD_POOL.isShutdown()) {
            THREAD_POOL = Executors.newCachedThreadPool();
        }
        THREAD_POOL.execute(this);
    }

    void log(E eventObject) {
        if (!this.queue.offer(eventObject)) {
            LOG.warn("Message queue is full. Ignored the message:" + System.lineSeparator() + eventObject.toString());
        } else if (this.start.compareAndSet(false, true)) {
            this.execute();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.append(this.queue.take());
            }
        }
        catch (InterruptedException e) {
            this.run();
        }
        catch (Exception e) {
            this.close();
        }
    }

    protected abstract void append(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        ExecutorService executorService = THREAD_POOL;
        synchronized (executorService) {
            if (!THREAD_POOL.isShutdown()) {
                DaemonAppender.shutdownAndAwaitTermination(THREAD_POOL);
            }
        }
    }

    private static void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

