/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.more.appenders.DaemonAppender;
import java.util.HashMap;
import java.util.Map;
import org.fluentd.logger.FluentLogger;

public class DataFluentAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private DaemonAppender<ILoggingEvent> appender;
    private int maxQueueSize;
    private String tag;
    private String label;
    private String remoteHost;
    private int port;
    private Map<String, String> additionalFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent eventObject) {
        if (this.appender == null) {
            DataFluentAppender dataFluentAppender = this;
            synchronized (dataFluentAppender) {
                this.appender = new FluentDaemonAppender(this.tag, this.label, this.remoteHost, this.port, this.maxQueueSize, this.additionalFields);
            }
        }
        eventObject.prepareForDeferredProcessing();
        this.appender.log(eventObject);
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            if (this.appender != null) {
                this.appender.close();
            }
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void addAdditionalField(Field field) {
        if (this.additionalFields == null) {
            this.additionalFields = new HashMap<String, String>();
        }
        this.additionalFields.put(field.getKey(), field.getValue());
    }

    public static class Field {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    private static final class FluentDaemonAppender
    extends DaemonAppender<ILoggingEvent> {
        private FluentLogger fluentLogger;
        private final String tag;
        private final String label;
        private final String remoteHost;
        private final int port;
        private final Map<String, String> additionalFields;

        FluentDaemonAppender(String tag, String label, String remoteHost, int port, int maxQueueSize, Map<String, String> additionalFields) {
            super(maxQueueSize);
            this.tag = tag;
            this.label = label;
            this.remoteHost = remoteHost;
            this.port = port;
            this.additionalFields = additionalFields;
        }

        @Override
        public void execute() {
            this.fluentLogger = FluentLogger.getLogger((String)this.tag, (String)this.remoteHost, (int)this.port);
            super.execute();
        }

        @Override
        protected void close() {
            try {
                super.close();
            }
            finally {
                if (this.fluentLogger != null) {
                    this.fluentLogger.close();
                }
            }
        }

        @Override
        protected void append(ILoggingEvent rawData) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("message", rawData.getFormattedMessage());
            data.put("logger", rawData.getLoggerName());
            data.put("thread", rawData.getThreadName());
            data.put("level", (String)rawData.getLevel());
            if (rawData.getMarker() != null) {
                data.put("marker", (String)rawData.getMarker());
            }
            if (rawData.hasCallerData()) {
                data.put("caller", new CallerDataConverter().convert(rawData));
            }
            if (rawData.getThrowableProxy() != null) {
                data.put("throwable", ThrowableProxyUtil.asString((IThrowableProxy)rawData.getThrowableProxy()));
            }
            if (this.additionalFields != null) {
                data.putAll(this.additionalFields);
            }
            for (Map.Entry entry : rawData.getMDCPropertyMap().entrySet()) {
                data.put((String)entry.getKey(), (String)entry.getValue());
            }
            this.fluentLogger.log(this.label, data, rawData.getTimeStamp() / 1000L);
        }
    }
}

