/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.more.appenders.DaemonAppender;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamoDBLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final int MSG_SIZE_LIMIT = 65535;
    private DaemonAppender<ILoggingEvent> appender;
    private String dynamodbCredentialFilePath;
    private String dynamodbEndpoint;
    private String outputTableName;
    private String instanceName;
    private int maxQueueSize;
    private Layout<ILoggingEvent> layout;

    private boolean initializeAppender() {
        try {
            PropertiesCredentials credentials = new PropertiesCredentials(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.dynamodbCredentialFilePath));
            AmazonDynamoDBClient dynamoClient = new AmazonDynamoDBClient((AWSCredentials)credentials);
            dynamoClient.setEndpoint(this.dynamodbEndpoint);
            this.appender = new DynamoDBDaemonAppender(this.outputTableName, this.instanceName, DynamoDBLogbackAppender.getLastId(this.outputTableName, this.instanceName, dynamoClient), dynamoClient, this.layout, this.maxQueueSize);
            return true;
        }
        catch (Exception e) {
            System.err.println("Could not initialize " + DynamoDBLogbackAppender.class.getCanonicalName() + " ( will try to initialize again later ): " + e);
            return false;
        }
    }

    private static long getLastId(String tableName, String instanceName, AmazonDynamoDBClient dynamoClient) {
        QueryRequest queryRequest = new QueryRequest().withTableName(tableName).withKeyConditionExpression("instance = :pk").addExpressionAttributeValuesEntry(":pk", new AttributeValue().withS(instanceName)).withScanIndexForward(Boolean.valueOf(false)).withLimit(Integer.valueOf(1));
        QueryResult result = dynamoClient.query(queryRequest);
        List items = result.getItems();
        if (items == null || items.size() == 0) {
            return 0L;
        }
        return Long.valueOf(((AttributeValue)((Map)items.get(0)).get("id")).getN());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent eventObject) {
        if (this.appender == null) {
            DynamoDBLogbackAppender dynamoDBLogbackAppender = this;
            synchronized (dynamoDBLogbackAppender) {
                if (!this.initializeAppender()) {
                    System.err.println("The log which supposed to be added to DynamoDB was not added because the dynamo db appender could not be initialized. Ignored the message: " + System.lineSeparator() + eventObject.toString());
                    return;
                }
            }
            this.append(eventObject);
            return;
        }
        eventObject.prepareForDeferredProcessing();
        this.appender.log(eventObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            super.stop();
        }
        finally {
            DynamoDBLogbackAppender dynamoDBLogbackAppender = this;
            synchronized (dynamoDBLogbackAppender) {
                if (this.appender != null) {
                    this.appender.close();
                }
            }
        }
    }

    public String getDynamodbCredentialFilePath() {
        return this.dynamodbCredentialFilePath;
    }

    public void setDynamodbCredentialFilePath(String dynamodbCredentialFilePath) {
        this.dynamodbCredentialFilePath = dynamodbCredentialFilePath;
    }

    public String getDynamodbEndpoint() {
        return this.dynamodbEndpoint;
    }

    public void setDynamodbEndpoint(String dynamodbEndpoint) {
        this.dynamodbEndpoint = dynamodbEndpoint;
    }

    public String getOutputTableName() {
        return this.outputTableName;
    }

    public void setOutputTableName(String outputTableName) {
        this.outputTableName = outputTableName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    private static final class DynamoDBDaemonAppender
    extends DaemonAppender<ILoggingEvent> {
        private final String tableName;
        private final String instanceName;
        private long id;
        private final AmazonDynamoDBClient dynamoClient;
        private final Layout<ILoggingEvent> layout;

        DynamoDBDaemonAppender(String tableName, String instanceName, long lastId, AmazonDynamoDBClient dynamoClient, Layout<ILoggingEvent> layout, int maxQueueSize) {
            super(maxQueueSize);
            this.tableName = tableName;
            this.instanceName = instanceName;
            this.id = lastId;
            this.dynamoClient = dynamoClient;
            this.layout = layout;
        }

        @Override
        protected void append(ILoggingEvent rawData) {
            String msg = null;
            msg = this.layout != null ? this.layout.doLayout((Object)rawData) : rawData.toString();
            if (msg != null && msg.length() > 65535) {
                msg = msg.substring(0, 65535);
            }
            HashMap<String, AttributeValue> data = new HashMap<String, AttributeValue>(4);
            data.put("instance", new AttributeValue().withS(this.instanceName));
            data.put("id", new AttributeValue().withN(String.valueOf(++this.id)));
            data.put("msg", new AttributeValue().withS(msg));
            PutItemRequest itemRequest = new PutItemRequest().withTableName(this.tableName).withItem(data);
            this.dynamoClient.putItem(itemRequest);
        }

        @Override
        protected void close() {
            try {
                super.close();
            }
            finally {
                this.dynamoClient.shutdown();
            }
        }
    }
}

