/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.more.appenders.DaemonAppender;
import java.util.HashMap;
import org.fluentd.logger.FluentLogger;

public class FluentLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final int MSG_SIZE_LIMIT = 65535;
    private DaemonAppender<ILoggingEvent> appender;
    private int maxQueueSize;
    private String tag;
    private String label;
    private String remoteHost;
    private int port;
    private Layout<ILoggingEvent> layout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent eventObject) {
        if (this.appender == null) {
            FluentLogbackAppender fluentLogbackAppender = this;
            synchronized (fluentLogbackAppender) {
                this.appender = new FluentDaemonAppender(this.tag, this.label, this.remoteHost, this.port, this.layout, this.maxQueueSize);
            }
        }
        eventObject.prepareForDeferredProcessing();
        this.appender.log(eventObject);
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            if (this.appender != null) {
                this.appender.close();
            }
        }
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    private static final class FluentDaemonAppender
    extends DaemonAppender<ILoggingEvent> {
        private FluentLogger fluentLogger;
        private final String tag;
        private final String label;
        private final String remoteHost;
        private final int port;
        private final Layout<ILoggingEvent> layout;

        FluentDaemonAppender(String tag, String label, String remoteHost, int port, Layout<ILoggingEvent> layout, int maxQueueSize) {
            super(maxQueueSize);
            this.tag = tag;
            this.label = label;
            this.remoteHost = remoteHost;
            this.port = port;
            this.layout = layout;
        }

        @Override
        public void execute() {
            this.fluentLogger = FluentLogger.getLogger((String)(this.label != null ? this.tag : null), (String)this.remoteHost, (int)this.port);
            super.execute();
        }

        @Override
        protected void close() {
            try {
                super.close();
            }
            finally {
                if (this.fluentLogger != null) {
                    this.fluentLogger.close();
                }
            }
        }

        @Override
        protected void append(ILoggingEvent rawData) {
            String msg = null;
            msg = this.layout != null ? this.layout.doLayout((Object)rawData) : rawData.toString();
            if (msg != null && msg.length() > 65535) {
                msg = msg.substring(0, 65535);
            }
            HashMap<String, String> data = new HashMap<String, String>(1);
            data.put("msg", msg);
            if (this.label == null) {
                this.fluentLogger.log(this.tag, data);
            } else {
                this.fluentLogger.log(this.label, data);
            }
        }
    }
}

