/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;

public abstract class AwsAppender<E>
extends UnsynchronizedAppenderBase<E> {
    protected AwsConfig config;
    protected AWSCredentialsProvider credentialsProvider;
    protected AWSCredentials credentials;

    public void start() {
        try {
            super.start();
            if (this.config.getCredentialFilePath() != null && this.config.getCredentialFilePath().length() > 0) {
                this.credentials = new PropertiesCredentials(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.config.getCredentialFilePath()));
            } else {
                this.credentialsProvider = this.config.getProfile() != null && this.config.getProfile().length() > 0 ? new ProfileCredentialsProvider(this.config.getProfile()) : DefaultAWSCredentialsProviderChain.getInstance();
            }
        }
        catch (Exception e) {
            this.addWarn("Could not initialize " + AwsAppender.class.getCanonicalName() + " ( will try to initialize again later ): " + e);
        }
    }

    public static class AwsConfig {
        private String credentialFilePath;
        private String region;
        private String profile;

        public void setCredentialFilePath(String credentialFilePath) {
            this.credentialFilePath = credentialFilePath;
        }

        public String getCredentialFilePath() {
            return this.credentialFilePath;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getProfile() {
            return this.profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }
    }
}

