/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.more.appenders.FluentdAppenderBase;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.komamitsu.fluency.EventTime;
import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.fluentd.FluencyBuilderForFluentd;

public class FluencyLogbackAppender<E>
extends FluentdAppenderBase<E> {
    private Fluency fluency;
    private String tag;
    private String remoteHost;
    private int port;
    private RemoteServers remoteServers;
    private boolean ackResponseMode;
    private String fileBackupDir;
    private Integer bufferChunkInitialSize;
    private Integer bufferChunkRetentionSize;
    private Long maxBufferSize;
    private Integer connectionTimeoutMilli;
    private Integer readTimeoutMilli;
    private Integer waitUntilBufferFlushed;
    private Integer waitUntilFlusherTerminated;
    private Integer flushIntervalMillis;
    private Integer senderMaxRetryCount;
    private boolean useEventTime;
    private boolean sslEnabled;

    @Deprecated
    public void setLayout(Layout<E> layout) {
        this.addWarn("This appender no longer admits a layout as a sub-component, set an encoder instead.");
        this.addWarn("To ensure compatibility, wrapping your layout in LayoutWrappingEncoder.");
        this.addWarn("See also http://logback.qos.ch/codes.html#layoutInsteadOfEncoder for details");
        LayoutWrappingEncoder lwe = new LayoutWrappingEncoder();
        lwe.setLayout(layout);
        lwe.setContext(this.context);
        this.encoder = lwe;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public void addAdditionalField(FluentdAppenderBase.Field field) {
        if (this.additionalFields == null) {
            this.additionalFields = new HashMap();
        }
        this.additionalFields.put(field.getKey(), field.getValue());
    }

    public boolean isFlattenMapMarker() {
        return this.flattenMapMarker;
    }

    public void setFlattenMapMarker(boolean flattenMapMarker) {
        this.flattenMapMarker = flattenMapMarker;
    }

    public void start() {
        super.start();
        try {
            FluencyBuilderForFluentd builder = this.configureFluency();
            this.fluency = builder.build(this.configureServers());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void append(E event) {
        Map<String, Object> data = this.createData(event);
        try {
            String tag;
            String string = tag = this.tag == null ? "" : this.tag;
            if (this.isUseEventTime()) {
                EventTime eventTime = EventTime.fromEpochMilli((long)System.currentTimeMillis());
                this.fluency.emit(tag, eventTime, data);
            } else {
                this.fluency.emit(tag, data);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.fluency.close();
            }
            catch (Exception exception) {}
        }
    }

    public RemoteServers getRemoteServers() {
        return this.remoteServers;
    }

    public void setRemoteServers(RemoteServers remoteServers) {
        this.remoteServers = remoteServers;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean useSsl) {
        this.sslEnabled = useSsl;
    }

    public boolean isAckResponseMode() {
        return this.ackResponseMode;
    }

    public void setAckResponseMode(boolean ackResponseMode) {
        this.ackResponseMode = ackResponseMode;
    }

    public String getFileBackupDir() {
        return this.fileBackupDir;
    }

    public void setFileBackupDir(String fileBackupDir) {
        this.fileBackupDir = fileBackupDir;
    }

    public Integer getBufferChunkInitialSize() {
        return this.bufferChunkInitialSize;
    }

    public void setBufferChunkInitialSize(Integer bufferChunkInitialSize) {
        this.bufferChunkInitialSize = bufferChunkInitialSize;
    }

    public Integer getBufferChunkRetentionSize() {
        return this.bufferChunkRetentionSize;
    }

    public void setBufferChunkRetentionSize(Integer bufferChunkRetentionSize) {
        this.bufferChunkRetentionSize = bufferChunkRetentionSize;
    }

    public Long getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(Long maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public Integer getConnectionTimeoutMilli() {
        return this.connectionTimeoutMilli;
    }

    public void setConnectionTimeoutMilli(Integer connectionTimeoutMilli) {
        this.connectionTimeoutMilli = connectionTimeoutMilli;
    }

    public Integer getReadTimeoutMilli() {
        return this.readTimeoutMilli;
    }

    public void setReadTimeoutMilli(Integer readTimeoutMilli) {
        this.readTimeoutMilli = readTimeoutMilli;
    }

    public Integer getWaitUntilBufferFlushed() {
        return this.waitUntilBufferFlushed;
    }

    public void setWaitUntilBufferFlushed(Integer waitUntilBufferFlushed) {
        this.waitUntilBufferFlushed = waitUntilBufferFlushed;
    }

    public Integer getWaitUntilFlusherTerminated() {
        return this.waitUntilFlusherTerminated;
    }

    public void setWaitUntilFlusherTerminated(Integer waitUntilFlusherTerminated) {
        this.waitUntilFlusherTerminated = waitUntilFlusherTerminated;
    }

    public Integer getFlushIntervalMillis() {
        return this.flushIntervalMillis;
    }

    public void setFlushIntervalMillis(Integer flushIntervalMillis) {
        this.flushIntervalMillis = flushIntervalMillis;
    }

    public Integer getSenderMaxRetryCount() {
        return this.senderMaxRetryCount;
    }

    public void setSenderMaxRetryCount(Integer senderMaxRetryCount) {
        this.senderMaxRetryCount = senderMaxRetryCount;
    }

    public boolean isUseEventTime() {
        return this.useEventTime;
    }

    public void setUseEventTime(boolean useEventTime) {
        this.useEventTime = useEventTime;
    }

    protected FluencyBuilderForFluentd configureFluency() {
        FluencyBuilderForFluentd builder = new FluencyBuilderForFluentd();
        builder.setAckResponseMode(this.ackResponseMode);
        if (this.fileBackupDir != null) {
            builder.setFileBackupDir(this.fileBackupDir);
        }
        if (this.bufferChunkInitialSize != null) {
            builder.setBufferChunkInitialSize(this.bufferChunkInitialSize);
        }
        if (this.bufferChunkRetentionSize != null) {
            builder.setBufferChunkRetentionSize(this.bufferChunkRetentionSize);
        }
        if (this.maxBufferSize != null) {
            builder.setMaxBufferSize(this.maxBufferSize);
        }
        if (this.connectionTimeoutMilli != null) {
            builder.setConnectionTimeoutMilli(this.connectionTimeoutMilli);
        }
        if (this.readTimeoutMilli != null) {
            builder.setReadTimeoutMilli(this.readTimeoutMilli);
        }
        if (this.waitUntilBufferFlushed != null) {
            builder.setWaitUntilBufferFlushed(this.waitUntilBufferFlushed);
        }
        if (this.waitUntilFlusherTerminated != null) {
            builder.setWaitUntilFlusherTerminated(this.waitUntilFlusherTerminated);
        }
        if (this.flushIntervalMillis != null) {
            builder.setFlushIntervalMillis(this.flushIntervalMillis);
        }
        if (this.senderMaxRetryCount != null) {
            builder.setSenderMaxRetryCount(this.senderMaxRetryCount);
        }
        builder.setSslEnabled(this.sslEnabled);
        return builder;
    }

    protected List<InetSocketAddress> configureServers() {
        ArrayList<InetSocketAddress> dest = new ArrayList<InetSocketAddress>();
        if (this.remoteHost != null && this.port > 0) {
            dest.add(new InetSocketAddress(this.remoteHost, this.port));
        }
        if (this.remoteServers != null) {
            for (RemoteServer server : this.remoteServers.getRemoteServers()) {
                dest.add(new InetSocketAddress(server.getHost(), server.getPort()));
            }
        }
        return dest;
    }

    public static class RemoteServer {
        private String host;
        private int port;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public static class RemoteServers {
        private List<RemoteServer> remoteServers = new ArrayList<RemoteServer>();

        public List<RemoteServer> getRemoteServers() {
            return this.remoteServers;
        }

        public void addRemoteServer(RemoteServer remoteServer) {
            this.remoteServers.add(remoteServer);
        }
    }
}

