/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import java.util.ArrayList;
import java.util.List;

public class IntervalEmitter<E, R> {
    private volatile long lastEmit = -1L;
    private long maxInterval;
    private volatile List<R> events = new ArrayList<R>();
    private final EventMapper<E, R> eventMapper;
    private final IntervalAppender<R> appender;

    IntervalEmitter(long maxInterval, EventMapper<E, R> eventMapper, IntervalAppender<R> appender) {
        this.maxInterval = maxInterval;
        this.eventMapper = eventMapper;
        this.appender = appender;
    }

    void append(E event) {
        long now = System.currentTimeMillis();
        if (now > this.lastEmit + this.maxInterval) {
            ArrayList<R> tmpEvents = new ArrayList<R>(this.events.size() + 3);
            ArrayList<R> copiedEvents = new ArrayList<R>(this.events);
            copiedEvents.add(this.eventMapper.map(event));
            this.events = tmpEvents;
            if (this.emit(copiedEvents)) {
                this.lastEmit = now;
            }
        } else {
            this.events.add(this.eventMapper.map(event));
        }
    }

    public boolean emit(List<R> copiedEvents) {
        if (!copiedEvents.isEmpty()) {
            if (this.appender.append(copiedEvents)) {
                return true;
            }
            this.events.addAll(0, copiedEvents);
            return false;
        }
        return true;
    }

    public void emitForShutdown(long waitMillis, int retry) {
        try {
            for (int i = 0; i < retry; ++i) {
                if (this.emit(this.events)) {
                    return;
                }
                Thread.sleep(waitMillis);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("Could not write the log: " + this.events);
    }

    public static interface IntervalAppender<R> {
        public boolean append(List<R> var1);
    }

    public static interface EventMapper<E, R> {
        public R map(E var1);
    }
}

