/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.more.appenders.encoder.ReplacePatternLayoutEncoderBase;

public class FastJsonEncoder
extends ReplacePatternLayoutEncoderBase {
    private static final char[][] FROM = new char[][]{{'\b'}, {'\f'}, {'\n'}, {'\r'}, {'\t'}, {'\"'}, {'\\'}};
    private static final char[][] TO = new char[][]{{'\\', 'b'}, {'\\', 'f'}, {'\\', 'n'}, {'\\', 'r'}, {'\\', 't'}, {'\\', '\"'}, {'\\', '\\'}};
    private static final ReplacePatternLayoutEncoderBase.ReplacePattern JSON_REPLACE_PATTERN = new ReplacePatternLayoutEncoderBase.ReplacePattern(FROM, TO);
    private boolean compressSpace;
    private final JsonWriter writer = new JsonWriter();

    public void setCompressSpace(boolean compressSpace) {
        this.compressSpace = compressSpace;
    }

    @Override
    protected ReplacePatternLayoutEncoderBase.ReplacePattern getReplacePattern() {
        return JSON_REPLACE_PATTERN;
    }

    @Override
    protected ReplacePatternLayoutEncoderBase.Writer getWriter() {
        return this.writer;
    }

    private final class JsonWriter
    implements ReplacePatternLayoutEncoderBase.Writer {
        private JsonWriter() {
        }

        @Override
        public void write(Converter<ILoggingEvent> converter, ILoggingEvent event, StringBuilder buf) {
            try {
                int start = buf.length();
                converter.write(buf, (Object)event);
                int end = buf.length();
                if (FastJsonEncoder.this.compressSpace && converter instanceof LiteralConverter) {
                    int segmentEndIndex = -1;
                    int segmentStartIndex = -1;
                    for (int i = start; i < end; ++i) {
                        char c = buf.charAt(i);
                        if (segmentEndIndex == -1 && (c == '\n' || c == ' ')) {
                            segmentEndIndex = i;
                        }
                        if (c == '\"' || c == '}') {
                            segmentStartIndex = i;
                        }
                        if (segmentEndIndex < 0 || segmentStartIndex < segmentEndIndex) continue;
                        buf.replace(segmentEndIndex, segmentStartIndex, " ");
                        end -= segmentStartIndex - segmentEndIndex;
                        segmentEndIndex = -1;
                        segmentStartIndex = -1;
                    }
                }
                if (converter instanceof DynamicConverter) {
                    char[] sub = new char[end - start];
                    buf.getChars(start, end, sub, 0);
                    String to = FastJsonEncoder.this.replace(sub);
                    buf.replace(start, end, to != null ? to : "");
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

