/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders.encoder;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;
import java.lang.reflect.Field;

public abstract class ReplacePatternLayoutEncoderBase
extends PatternLayoutEncoderBase<ILoggingEvent> {
    private char[][] from;
    private char[][] to;

    protected abstract ReplacePattern getReplacePattern();

    protected abstract Writer getWriter();

    public void start() {
        ReplacePattern replacePattern = this.getReplacePattern();
        this.from = replacePattern.from;
        this.to = replacePattern.to;
        ReplacePatternLayout patternLayout = new ReplacePatternLayout(this.getWriter());
        patternLayout.setContext(this.context);
        patternLayout.setPattern(this.getPattern());
        patternLayout.setOutputPatternAsHeader(this.outputPatternAsHeader);
        patternLayout.start();
        this.layout = patternLayout;
        super.start();
    }

    public byte[] encode(ILoggingEvent event) {
        return super.encode((Object)event);
    }

    public String replace(char[] chars) {
        StringBuilder replaced = new StringBuilder((int)((double)chars.length * 1.5));
        block0: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            block1: for (int j = 0; j < this.from.length; ++j) {
                char[] f = this.from[j];
                for (int k = 0; k < f.length; ++k) {
                    if (f[k] != chars[i + k]) continue block1;
                }
                replaced.append(this.to[j]);
                continue block0;
            }
            replaced.append(c);
        }
        return replaced.toString();
    }

    protected static class ReplacePatternLayout
    extends PatternLayout {
        Converter<ILoggingEvent> head;
        private Writer writer;

        public ReplacePatternLayout(Writer writer) {
            this.writer = writer;
        }

        public void start() {
            super.start();
            try {
                Field headField = PatternLayoutBase.class.getDeclaredField("head");
                headField.setAccessible(true);
                this.head = (Converter)headField.get((Object)this);
                headField.setAccessible(false);
            }
            catch (Exception e) {
                throw new RuntimeException("Please raise the issue.", e);
            }
        }

        protected String writeLoopOnConverters(ILoggingEvent event) {
            StringBuilder buf = new StringBuilder(256);
            for (Converter c = this.head; c != null; c = c.getNext()) {
                this.writer.write(c, event, buf);
            }
            return buf.toString();
        }
    }

    protected static class ReplacePattern {
        private final char[][] from;
        private final char[][] to;

        public ReplacePattern(char[][] from, char[][] to) {
            this.from = from;
            this.to = to;
        }
    }

    public static interface Writer {
        public void write(Converter<ILoggingEvent> var1, ILoggingEvent var2, StringBuilder var3);
    }
}

