/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.more.appenders.marker.MapMarker;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Marker;

abstract class FluentdAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    private static final String DATA_MESSAGE = "message";
    private static final String DATA_LOGGER = "logger";
    private static final String DATA_THREAD = "thread";
    private static final String DATA_LEVEL = "level";
    private static final String DATA_MARKER = "marker";
    private static final String DATA_CALLER = "caller";
    private static final String DATA_THROWABLE = "throwable";
    protected Encoder<E> encoder = new EchoEncoder();
    protected Map<String, String> additionalFields;
    protected boolean flattenMapMarker;

    FluentdAppenderBase() {
    }

    protected Map<String, Object> createData(E event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (event instanceof ILoggingEvent) {
            ILoggingEvent loggingEvent = (ILoggingEvent)event;
            data.put(DATA_MESSAGE, loggingEvent.getFormattedMessage());
            data.put(DATA_LOGGER, loggingEvent.getLoggerName());
            data.put(DATA_THREAD, loggingEvent.getThreadName());
            data.put(DATA_LEVEL, loggingEvent.getLevel().levelStr);
            Marker marker = loggingEvent.getMarker();
            if (marker != null) {
                if (marker instanceof MapMarker) {
                    this.extractMapMarker((MapMarker)marker, data);
                } else {
                    data.put(DATA_MARKER, marker.toString());
                    if (marker.hasReferences()) {
                        for (Marker nestedMarker : marker) {
                            if (!(nestedMarker instanceof MapMarker)) continue;
                            this.extractMapMarker((MapMarker)nestedMarker, data);
                        }
                    }
                }
            }
            if (loggingEvent.hasCallerData()) {
                data.put(DATA_CALLER, new CallerDataConverter().convert(loggingEvent));
            }
            if (loggingEvent.getThrowableProxy() != null) {
                data.put(DATA_THROWABLE, ThrowableProxyUtil.asString((IThrowableProxy)loggingEvent.getThrowableProxy()));
            }
            for (Map.Entry entry : loggingEvent.getMDCPropertyMap().entrySet()) {
                data.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            data.put(DATA_MESSAGE, this.encoder.encode(event));
        }
        if (this.additionalFields != null) {
            data.putAll(this.additionalFields);
        }
        return data;
    }

    private void extractMapMarker(MapMarker mapMarker, Map<String, Object> data) {
        if (this.flattenMapMarker) {
            data.putAll(mapMarker.getMap());
        } else {
            data.put("marker." + mapMarker.getName(), mapMarker.getMap());
        }
    }

    public static class Field {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

