/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.more.appenders.AwsAppender;
import ch.qos.logback.more.appenders.IntervalEmitter;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.LogGroup;
import com.amazonaws.services.logs.model.LogStream;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class CloudWatchLogbackAppender<E>
extends AwsAppender<E> {
    private IntervalEmitter<E, InputLogEvent> emitter;
    private AWSLogs awsLogs;
    private String logGroupName;
    private StreamName logStreamName;
    private boolean createLogDestination;
    private long emitInterval = 10000L;
    private Encoder<E> encoder = new EchoEncoder();

    public void setAwsConfig(AwsAppender.AwsConfig config) {
        this.config = config;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = new StaticStreamName(logStreamName);
    }

    public void setLogStreamRolling(StreamName streamName) {
        this.logStreamName = streamName;
    }

    public void setCreateLogDestination(boolean createLogDestination) {
        this.createLogDestination = createLogDestination;
    }

    public void setEmitInterval(long emitInterval) {
        this.emitInterval = emitInterval;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    @Override
    public void start() {
        if (this.logGroupName == null || this.logGroupName.length() == 0 || this.logStreamName == null) {
            throw new IllegalArgumentException("logGroupName and logStreamName must be defined.");
        }
        this.emitter = new IntervalEmitter(this.emitInterval, new CloudWatchEventMapper(), new CloudWatchIntervalAppender());
        super.start();
    }

    public void stop() {
        try {
            this.emitter.emitForShutdown(10000L, 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.stop();
        }
        finally {
            try {
                this.awsLogs.shutdown();
            }
            catch (Exception exception) {}
        }
    }

    protected void append(E eventObject) {
        this.emitter.append(eventObject);
    }

    private void ensureLogGroup() {
        DescribeLogGroupsRequest request;
        DescribeLogGroupsResult result;
        if (this.awsLogs == null) {
            AWSLogsClientBuilder builder = (AWSLogsClientBuilder)AWSLogsClientBuilder.standard().withRegion(this.config.getRegion());
            if (this.credentials != null) {
                builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.credentials));
            } else if (this.credentialsProvider != null) {
                builder.withCredentials(this.credentialsProvider);
            }
            this.awsLogs = (AWSLogs)builder.build();
        }
        if ((result = this.awsLogs.describeLogGroups(request = new DescribeLogGroupsRequest().withLogGroupNamePrefix(this.logGroupName).withLimit(Integer.valueOf(1)))).getLogGroups().size() == 1 && ((LogGroup)result.getLogGroups().get(0)).getLogGroupName().equals(this.logGroupName)) {
            return;
        }
        if (!this.createLogDestination) {
            throw new IllegalStateException("The specified log group does not exist: " + this.logGroupName);
        }
        this.awsLogs.createLogGroup(new CreateLogGroupRequest(this.logGroupName));
    }

    private String ensureLogStream(String name) {
        DescribeLogStreamsRequest request = new DescribeLogStreamsRequest().withLogGroupName(this.logGroupName).withLogStreamNamePrefix(name).withLimit(Integer.valueOf(1));
        DescribeLogStreamsResult result = this.awsLogs.describeLogStreams(request);
        if (result.getLogStreams().size() == 1 && ((LogStream)result.getLogStreams().get(0)).getLogStreamName().equals(name)) {
            return ((LogStream)result.getLogStreams().get(0)).getUploadSequenceToken();
        }
        if (this.createLogDestination) {
            this.awsLogs.createLogStream(new CreateLogStreamRequest(this.logGroupName, name));
            return null;
        }
        throw new IllegalStateException("The specified log stream does not exist: " + this.logStreamName);
    }

    public static class CountBasedStreamName
    implements StreamName {
        private long count = 0L;
        private long limit = 1000L;
        private String baseName = "";
        private String currentName;

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public void setLimit(long limit) {
            this.limit = limit;
            this.count = limit + 1L;
        }

        @Override
        public String get(List<InputLogEvent> events) {
            if (this.currentName == null) {
                this.currentName = this.baseName + UUID.randomUUID();
                return this.currentName;
            }
            this.count += (long)events.size();
            if (this.count > this.limit) {
                this.currentName = this.baseName + UUID.randomUUID();
                this.count = events.size();
            }
            return this.currentName;
        }
    }

    public static class StaticStreamName
    implements StreamName {
        private String name;

        public StaticStreamName(String name) {
            this.name = name;
        }

        @Override
        public String get(List<InputLogEvent> events) {
            return this.name;
        }
    }

    public static interface StreamName {
        public String get(List<InputLogEvent> var1);
    }

    private final class CloudWatchIntervalAppender
    implements IntervalEmitter.IntervalAppender<InputLogEvent> {
        private String sequenceToken;
        private boolean initialized = false;
        private boolean switchingStream = false;
        private String currentStreamName = CloudWatchLogbackAppender.access$300(CloudWatchLogbackAppender.this).get(Collections.emptyList());

        private CloudWatchIntervalAppender() {
        }

        @Override
        public boolean append(List<InputLogEvent> events) {
            if (!this.initialized) {
                CloudWatchLogbackAppender.this.ensureLogGroup();
                this.initialized = true;
            }
            if (this.switchingStream) {
                return false;
            }
            String streamName = CloudWatchLogbackAppender.this.logStreamName.get(events);
            if (!streamName.equals(this.currentStreamName)) {
                if (this.switchingStream) {
                    return false;
                }
                this.switchingStream = true;
                this.sequenceToken = CloudWatchLogbackAppender.this.ensureLogStream(streamName);
                this.currentStreamName = streamName;
                this.switchingStream = false;
            }
            try {
                PutLogEventsRequest request = new PutLogEventsRequest(CloudWatchLogbackAppender.this.logGroupName, streamName, events);
                if (this.sequenceToken != null) {
                    request.withSequenceToken(this.sequenceToken);
                }
                PutLogEventsResult result = CloudWatchLogbackAppender.this.awsLogs.putLogEvents(request);
                this.sequenceToken = result.getNextSequenceToken();
                return true;
            }
            catch (RuntimeException e) {
                this.sequenceToken = null;
                e.printStackTrace();
                throw e;
            }
        }
    }

    private final class CloudWatchEventMapper
    implements IntervalEmitter.EventMapper<E, InputLogEvent> {
        private CloudWatchEventMapper() {
        }

        @Override
        public InputLogEvent map(E event) {
            InputLogEvent logEvent = new InputLogEvent();
            logEvent.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            logEvent.setMessage(new String(CloudWatchLogbackAppender.this.encoder.encode(event)));
            return logEvent;
        }
    }
}

