/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders.filter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Marker;

public class AppendersMarkerFilter
extends AbstractMatcherFilter<ILoggingEvent> {
    private List<String> markers = new ArrayList<String>();

    public AppendersMarkerFilter() {
        this.setOnMatch(FilterReply.NEUTRAL);
        this.setOnMismatch(FilterReply.DENY);
    }

    public void addMarker(String markerStr) {
        this.markers.add(markerStr);
    }

    public void start() {
        if (!this.markers.isEmpty()) {
            super.start();
        } else {
            String name = this.getName();
            this.addError("No marker set for filter " + (name != null ? name : ((Object)((Object)this)).getClass()));
        }
    }

    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        Marker eventsMarker = event.getMarker();
        if (eventsMarker == null) {
            return this.onMismatch;
        }
        for (String markerStr : this.markers) {
            if (!eventsMarker.contains(markerStr)) continue;
            return this.onMatch;
        }
        return this.onMismatch;
    }
}

