/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.more.appenders.AwsAppender;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;

public abstract class KinesisStreamAppenderBase<E>
extends AwsAppender<E> {
    protected AmazonKinesis kinesis;
    protected String streamName;
    protected int shardCount;
    protected boolean createStreamDestination;
    protected Encoder<E> encoder = new EchoEncoder();
    protected volatile boolean active;

    @Override
    public void start() {
        if (this.streamName == null || this.streamName.length() == 0) {
            throw new IllegalArgumentException("streamName must be defined.");
        }
        super.start();
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.kinesis.shutdown();
            }
            catch (Exception exception) {}
        }
    }

    protected void ensureKinesisStream() {
        if (this.kinesis == null) {
            this.kinesis = (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.credentials))).withRegion(this.config.getRegion())).build();
        }
        try {
            this.kinesis.describeStream(this.streamName);
            this.active = true;
            return;
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    CreateStreamRequest createStreamRequest = new CreateStreamRequest();
                    createStreamRequest.setStreamName(KinesisStreamAppenderBase.this.streamName);
                    createStreamRequest.setShardCount(Integer.valueOf(KinesisStreamAppenderBase.this.shardCount));
                    KinesisStreamAppenderBase.this.kinesis.createStream(createStreamRequest);
                    DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest();
                    describeStreamRequest.setStreamName(KinesisStreamAppenderBase.this.streamName);
                    long startTime = System.currentTimeMillis();
                    long endTime = startTime + 120000L;
                    do {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            DescribeStreamResult describeStreamResponse = KinesisStreamAppenderBase.this.kinesis.describeStream(describeStreamRequest);
                            String streamStatus = describeStreamResponse.getStreamDescription().getStreamStatus();
                            if (streamStatus.equals("ACTIVE")) {
                                KinesisStreamAppenderBase.this.active = true;
                                return;
                            }
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            // empty catch block
                        }
                    } while (System.currentTimeMillis() < endTime);
                    KinesisStreamAppenderBase.this.addError("Stream " + KinesisStreamAppenderBase.this.streamName + " never went active.");
                }
            });
            th.setDaemon(true);
            th.start();
            return;
        }
    }

    public static interface PartitionKey<E> {
        public String get(E var1);
    }
}

