/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.core.AppenderBase;
import java.util.Properties;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public abstract class AwsAppenderV2<E>
extends AppenderBase<E> {
    protected AwsConfig config;
    protected AwsCredentialsProvider credentialsProvider;
    protected AwsCredentials credentials;

    public void start() {
        try {
            if (this.config.getCredentialFilePath() != null && this.config.getCredentialFilePath().length() > 0) {
                Properties props = new Properties();
                props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.config.getCredentialFilePath()));
                this.credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)props.getProperty("accessKey"), (String)props.getProperty("secretKey")));
            } else {
                this.credentialsProvider = this.config.getProfile() != null && this.config.getProfile().length() > 0 ? DefaultCredentialsProvider.builder().profileName(this.config.getProfile()).build() : DefaultCredentialsProvider.create();
            }
            super.start();
        }
        catch (Exception e) {
            this.addWarn("Could not initialize " + AwsAppenderV2.class.getCanonicalName() + " ( will try to initialize again later ): " + e);
        }
    }

    public static class AwsConfig {
        private String credentialFilePath;
        private String region;
        private String profile;

        public void setCredentialFilePath(String credentialFilePath) {
            this.credentialFilePath = credentialFilePath;
        }

        public String getCredentialFilePath() {
            return this.credentialFilePath;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getProfile() {
            return this.profile;
        }

        public void setProfile(String profile) {
            this.profile = profile;
        }
    }
}

