/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.more.appenders.AwsAppenderV2;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.StreamStatus;

public abstract class KinesisStreamAppenderBaseV2<E>
extends AwsAppenderV2<E> {
    protected KinesisClient kinesis;
    protected String streamName;
    protected int shardCount;
    protected boolean createStreamDestination;
    protected Encoder<E> encoder = new EchoEncoder();
    protected volatile boolean active;

    @Override
    public void start() {
        if (this.streamName == null || this.streamName.length() == 0) {
            throw new IllegalArgumentException("streamName must be defined.");
        }
        super.start();
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.kinesis.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void ensureKinesisStream() {
        if (this.kinesis == null) {
            KinesisClientBuilder builder = (KinesisClientBuilder)KinesisClient.builder().region(Region.of((String)this.config.getRegion()));
            if (this.credentials != null) {
                builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)this.credentials));
            } else if (this.credentialsProvider != null) {
                builder.credentialsProvider(this.credentialsProvider);
            }
            this.kinesis = (KinesisClient)builder.build();
        }
        try {
            DescribeStreamRequest request = (DescribeStreamRequest)DescribeStreamRequest.builder().streamName(this.streamName).build();
            this.kinesis.describeStream(request);
            this.active = true;
            return;
        }
        catch (ResourceNotFoundException request) {
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    CreateStreamRequest createStreamRequest = (CreateStreamRequest)CreateStreamRequest.builder().streamName(KinesisStreamAppenderBaseV2.this.streamName).shardCount(Integer.valueOf(KinesisStreamAppenderBaseV2.this.shardCount)).build();
                    KinesisStreamAppenderBaseV2.this.kinesis.createStream(createStreamRequest);
                    DescribeStreamRequest describeStreamRequest = (DescribeStreamRequest)DescribeStreamRequest.builder().streamName(KinesisStreamAppenderBaseV2.this.streamName).build();
                    long startTime = System.currentTimeMillis();
                    long endTime = startTime + 120000L;
                    do {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            DescribeStreamResponse describeStreamResponse = KinesisStreamAppenderBaseV2.this.kinesis.describeStream(describeStreamRequest);
                            StreamStatus streamStatus = describeStreamResponse.streamDescription().streamStatus();
                            if (streamStatus.equals((Object)StreamStatus.ACTIVE)) {
                                KinesisStreamAppenderBaseV2.this.active = true;
                                return;
                            }
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            // empty catch block
                        }
                    } while (System.currentTimeMillis() < endTime);
                    KinesisStreamAppenderBaseV2.this.addError("Stream " + KinesisStreamAppenderBaseV2.this.streamName + " never went active.");
                }
            });
            th.setDaemon(true);
            th.start();
            return;
        }
    }

    public static interface PartitionKey<E> {
        public String get(E var1);
    }
}

