/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.more.appenders.AwsAppender;
import ch.qos.logback.more.appenders.IntervalEmitter;
import ch.qos.logback.more.appenders.KinesisStreamAppenderBase;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class KinesisStreamLogbackAppender
extends KinesisStreamAppenderBase<ILoggingEvent> {
    private IntervalEmitter<ILoggingEvent, PutRecordsRequestEntry> emitter;
    private KinesisStreamAppenderBase.PartitionKey<ILoggingEvent> partitionKey = new RandomPartitionKey();
    private long emitInterval = 10000L;

    public void setAwsConfig(AwsAppender.AwsConfig config) {
        this.config = config;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public void setCreateStreamDestination(boolean createStreamDestination) {
        this.createStreamDestination = createStreamDestination;
    }

    public void setPartitionKey(KinesisStreamAppenderBase.PartitionKey<ILoggingEvent> partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void setEmitInterval(long emitInterval) {
        this.emitInterval = emitInterval;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    @Override
    public void start() {
        this.emitter = new IntervalEmitter<ILoggingEvent, PutRecordsRequestEntry>(this.emitInterval, new KinesisEventMapper(), new KinesisIntervalAppender());
        super.start();
    }

    @Override
    public void stop() {
        try {
            this.emitter.emitForShutdown(10000L, 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void append(ILoggingEvent eventObject) {
        this.emitter.append(eventObject);
    }

    public static class RandomPartitionKey
    implements KinesisStreamAppenderBase.PartitionKey<ILoggingEvent> {
        private Random rand = new Random();
        private int maxPartition = 10000;

        @Override
        public String get(ILoggingEvent event) {
            return String.valueOf(this.rand.nextInt(this.maxPartition));
        }
    }

    private final class KinesisEventMapper
    implements IntervalEmitter.EventMapper<ILoggingEvent, PutRecordsRequestEntry> {
        private KinesisEventMapper() {
        }

        @Override
        public PutRecordsRequestEntry map(ILoggingEvent event) {
            PutRecordsRequestEntry entry = new PutRecordsRequestEntry();
            entry.setData(ByteBuffer.wrap(KinesisStreamLogbackAppender.this.encoder.encode((Object)event)));
            entry.setPartitionKey(KinesisStreamLogbackAppender.this.partitionKey.get(event));
            return entry;
        }
    }

    private final class KinesisIntervalAppender
    implements IntervalEmitter.IntervalAppender<PutRecordsRequestEntry> {
        private KinesisIntervalAppender() {
        }

        @Override
        public boolean append(List<PutRecordsRequestEntry> entries) {
            if (!KinesisStreamLogbackAppender.this.active) {
                KinesisStreamLogbackAppender.this.ensureKinesisStream();
            }
            return this.append(entries, 0);
        }

        private boolean append(List<PutRecordsRequestEntry> entries, int retryCount) {
            if (retryCount > 3) {
                StringBuilder sb = new StringBuilder("Could not append the Kinesis stream entry. Failed entries:");
                for (PutRecordsRequestEntry entry : entries) {
                    sb.append(System.lineSeparator()).append(entry.getData());
                }
                KinesisStreamLogbackAppender.this.addError(sb.toString());
                return true;
            }
            try {
                if (retryCount > 0) {
                    Thread.sleep(1000 * retryCount);
                }
                PutRecordsRequest putRecordsRequest = new PutRecordsRequest();
                putRecordsRequest.setStreamName(KinesisStreamLogbackAppender.this.streamName);
                putRecordsRequest.setRecords(entries);
                PutRecordsResult putRecordsResult = KinesisStreamLogbackAppender.this.kinesis.putRecords(putRecordsRequest);
                if (putRecordsResult.getFailedRecordCount() == 0) {
                    return true;
                }
                if (putRecordsResult.getFailedRecordCount().intValue() == entries.size()) {
                    return false;
                }
                ArrayList<PutRecordsRequestEntry> failedEntries = new ArrayList<PutRecordsRequestEntry>(putRecordsResult.getFailedRecordCount());
                for (int i = 0; i < entries.size(); ++i) {
                    PutRecordsResultEntry resultEntry = (PutRecordsResultEntry)putRecordsResult.getRecords().get(i);
                    if (resultEntry.getErrorCode() != null) {
                        failedEntries.add(entries.get(i));
                    }
                    this.append(failedEntries, retryCount + 1);
                }
            }
            catch (RuntimeException e) {
                KinesisStreamLogbackAppender.this.addError("Unexpected runtime error while appending kinesis entries.", e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
    }

    public static class SinglePartitionKey
    implements KinesisStreamAppenderBase.PartitionKey<ILoggingEvent> {
        @Override
        public String get(ILoggingEvent event) {
            return "0";
        }
    }
}

