/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.more.appenders.AwsAppenderV2;
import ch.qos.logback.more.appenders.IntervalEmitter;
import ch.qos.logback.more.appenders.KinesisStreamAppenderBaseV2;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;

public class KinesisStreamLogbackAppenderV2
extends KinesisStreamAppenderBaseV2<ILoggingEvent> {
    private IntervalEmitter<ILoggingEvent, PutRecordsRequestEntry> emitter;
    private KinesisStreamAppenderBaseV2.PartitionKey<ILoggingEvent> partitionKey = new RandomPartitionKey();
    private long emitInterval = 10000L;

    public void setAwsConfig(AwsAppenderV2.AwsConfig config) {
        this.config = config;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public void setCreateStreamDestination(boolean createStreamDestination) {
        this.createStreamDestination = createStreamDestination;
    }

    public void setPartitionKey(KinesisStreamAppenderBaseV2.PartitionKey<ILoggingEvent> partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void setEmitInterval(long emitInterval) {
        this.emitInterval = emitInterval;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    @Override
    public void start() {
        this.emitter = new IntervalEmitter<ILoggingEvent, PutRecordsRequestEntry>(this.emitInterval, new KinesisEventMapper(), new KinesisIntervalAppender());
        super.start();
    }

    @Override
    public void stop() {
        try {
            this.emitter.emitForShutdown(10000L, 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            super.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void append(ILoggingEvent eventObject) {
        this.emitter.append(eventObject);
    }

    public static class RandomPartitionKey
    implements KinesisStreamAppenderBaseV2.PartitionKey<ILoggingEvent> {
        private Random rand = new Random();
        private int maxPartition = 10000;

        @Override
        public String get(ILoggingEvent event) {
            return String.valueOf(this.rand.nextInt(this.maxPartition));
        }
    }

    private final class KinesisEventMapper
    implements IntervalEmitter.EventMapper<ILoggingEvent, PutRecordsRequestEntry> {
        private KinesisEventMapper() {
        }

        @Override
        public PutRecordsRequestEntry map(ILoggingEvent event) {
            PutRecordsRequestEntry entry = (PutRecordsRequestEntry)PutRecordsRequestEntry.builder().data(SdkBytes.fromByteArray((byte[])KinesisStreamLogbackAppenderV2.this.encoder.encode((Object)event))).partitionKey(KinesisStreamLogbackAppenderV2.this.partitionKey.get(event)).build();
            return entry;
        }
    }

    private final class KinesisIntervalAppender
    implements IntervalEmitter.IntervalAppender<PutRecordsRequestEntry> {
        private KinesisIntervalAppender() {
        }

        @Override
        public boolean append(List<PutRecordsRequestEntry> entries) {
            if (!KinesisStreamLogbackAppenderV2.this.active) {
                KinesisStreamLogbackAppenderV2.this.ensureKinesisStream();
            }
            return this.append(entries, 0);
        }

        private boolean append(List<PutRecordsRequestEntry> entries, int retryCount) {
            if (retryCount > 3) {
                StringBuilder sb = new StringBuilder("Could not append the Kinesis stream entry. Failed entries:");
                for (PutRecordsRequestEntry entry : entries) {
                    sb.append(System.lineSeparator()).append(entry.data());
                }
                KinesisStreamLogbackAppenderV2.this.addError(sb.toString());
                return true;
            }
            try {
                PutRecordsRequest putRecordsRequest;
                PutRecordsResponse putRecordsResult;
                if (retryCount > 0) {
                    Thread.sleep(1000 * retryCount);
                }
                if ((putRecordsResult = KinesisStreamLogbackAppenderV2.this.kinesis.putRecords(putRecordsRequest = (PutRecordsRequest)PutRecordsRequest.builder().streamName(KinesisStreamLogbackAppenderV2.this.streamName).records(entries).build())).failedRecordCount() == 0) {
                    return true;
                }
                if (putRecordsResult.failedRecordCount().intValue() == entries.size()) {
                    return false;
                }
                ArrayList<PutRecordsRequestEntry> failedEntries = new ArrayList<PutRecordsRequestEntry>(putRecordsResult.failedRecordCount());
                for (int i = 0; i < entries.size(); ++i) {
                    PutRecordsResultEntry resultEntry = (PutRecordsResultEntry)putRecordsResult.records().get(i);
                    if (resultEntry.errorCode() != null) {
                        failedEntries.add(entries.get(i));
                    }
                    this.append(failedEntries, retryCount + 1);
                }
            }
            catch (RuntimeException e) {
                KinesisStreamLogbackAppenderV2.this.addError("Unexpected runtime error while appending kinesis entries.", e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
    }

    public static class SinglePartitionKey
    implements KinesisStreamAppenderBaseV2.PartitionKey<ILoggingEvent> {
        @Override
        public String get(ILoggingEvent event) {
            return "0";
        }
    }
}

