/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders;

import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.more.appenders.marker.MapMarker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;

public abstract class FluentdAppenderBase<E>
extends AppenderBase<E> {
    private static final String DATA_MESSAGE = "message";
    private static final String DATA_LOGGER = "logger";
    private static final String DATA_THREAD = "thread";
    private static final String DATA_LEVEL = "level";
    private static final String DATA_MARKER = "marker";
    private static final String DATA_CALLER = "caller";
    private static final String DATA_THROWABLE = "throwable";
    private Encoder<E> encoder;
    protected Map<String, String> additionalFields;
    private boolean flattenMapMarker;
    private String markerPrefix = "marker";
    private String messageFieldKeyName = "message";
    private List<String> ignoredFields;
    private String tag;
    private String remoteHost;
    private int port;
    private boolean useEventTime;

    protected Map<String, Object> createData(E event) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (event instanceof ILoggingEvent) {
            ILoggingEvent loggingEvent = (ILoggingEvent)event;
            data.put(this.messageFieldKeyName, this.encoder != null ? (Object)this.encoder.encode(event) : loggingEvent.getFormattedMessage());
            data.put(DATA_LOGGER, loggingEvent.getLoggerName());
            data.put(DATA_THREAD, loggingEvent.getThreadName());
            data.put(DATA_LEVEL, loggingEvent.getLevel().levelStr);
            Marker marker = loggingEvent.getMarker();
            if (marker != null) {
                if (marker instanceof MapMarker) {
                    this.extractMapMarker((MapMarker)marker, data);
                } else {
                    data.put(this.markerName(), marker.toString());
                    if (marker.hasReferences()) {
                        for (Marker nestedMarker : marker) {
                            if (!(nestedMarker instanceof MapMarker)) continue;
                            this.extractMapMarker((MapMarker)nestedMarker, data);
                        }
                    }
                }
            }
            if (loggingEvent.hasCallerData()) {
                data.put(DATA_CALLER, new CallerDataConverter().convert(loggingEvent));
            }
            if (loggingEvent.getThrowableProxy() != null) {
                data.put(DATA_THROWABLE, ThrowableProxyUtil.asString((IThrowableProxy)loggingEvent.getThrowableProxy()));
            }
            for (Map.Entry entry : loggingEvent.getMDCPropertyMap().entrySet()) {
                data.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            data.put(this.messageFieldKeyName, this.encoder != null ? (Object)this.encoder.encode(event) : event.toString());
        }
        if (this.additionalFields != null) {
            data.putAll(this.additionalFields);
        }
        if (this.ignoredFields != null) {
            this.ignoredFields.stream().forEach(data::remove);
        }
        return data;
    }

    protected void extractMapMarker(MapMarker mapMarker, Map<String, Object> data) {
        if (this.flattenMapMarker) {
            data.putAll(mapMarker.getMap());
        } else {
            data.put(this.mapMarkerName(mapMarker), mapMarker.getMap());
        }
    }

    public static boolean emptyString(String string) {
        return string == null || string.isEmpty();
    }

    protected String markerName() {
        return FluentdAppenderBase.emptyString(this.markerPrefix) ? DATA_MARKER : this.markerPrefix;
    }

    protected String mapMarkerName(MapMarker mapMarker) {
        if (mapMarker == null || FluentdAppenderBase.emptyString(mapMarker.getName())) {
            return this.markerName();
        }
        if (FluentdAppenderBase.emptyString(this.markerPrefix)) {
            return mapMarker.getName();
        }
        return this.markerPrefix + "." + mapMarker.getName();
    }

    public void addAdditionalField(Field field) {
        if (this.additionalFields == null) {
            this.additionalFields = new HashMap<String, String>();
        }
        this.additionalFields.put(field.getKey(), field.getValue());
    }

    public void addIgnoredField(String fieldName) {
        if (this.ignoredFields == null) {
            this.ignoredFields = new ArrayList<String>();
        }
        this.ignoredFields.add(fieldName);
    }

    @Deprecated
    public void setLayout(Layout<E> layout) {
        this.addWarn("This appender no longer admits a layout as a sub-component, set an encoder instead.");
        this.addWarn("To ensure compatibility, wrapping your layout in LayoutWrappingEncoder.");
        this.addWarn("See also http://logback.qos.ch/codes.html#layoutInsteadOfEncoder for details");
        LayoutWrappingEncoder lwe = new LayoutWrappingEncoder();
        lwe.setLayout(layout);
        lwe.setContext(this.context);
        this.setEncoder((Encoder<E>)lwe);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUseEventTime() {
        return this.useEventTime;
    }

    public void setUseEventTime(boolean useEventTime) {
        this.useEventTime = useEventTime;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public String getMessageFieldKeyName() {
        return this.messageFieldKeyName;
    }

    public void setMessageFieldKeyName(String messageFieldKeyName) {
        this.messageFieldKeyName = messageFieldKeyName;
    }

    public boolean isFlattenMapMarker() {
        return this.flattenMapMarker;
    }

    public void setFlattenMapMarker(boolean flattenMapMarker) {
        this.flattenMapMarker = flattenMapMarker;
    }

    public String getMarkerPrefix() {
        return this.markerPrefix;
    }

    public void setMarkerPrefix(String markerPrefix) {
        this.markerPrefix = markerPrefix != null ? markerPrefix : DATA_MARKER;
    }

    public static class Field {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

