/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.more.appenders.encoder;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.more.appenders.encoder.ReplacePatternLayoutEncoderBase;

public class FastJsonEncoder
extends ReplacePatternLayoutEncoderBase {
    private static final char[][] FROM = new char[][]{{'\b'}, {'\f'}, {'\n'}, {'\r'}, {'\t'}, {'\"'}, {'\\'}};
    private static final char[][] TO = new char[][]{{'\\', 'b'}, {'\\', 'f'}, {'\\', 'n'}, {'\\', 'r'}, {'\\', 't'}, {'\\', '\"'}, {'\\', '\\'}};
    private static final ReplacePatternLayoutEncoderBase.ReplacePattern JSON_REPLACE_PATTERN = new ReplacePatternLayoutEncoderBase.ReplacePattern(FROM, TO);
    private boolean compressSpace;
    private final JsonWriter writer = new JsonWriter();

    public void setCompressSpace(boolean compressSpace) {
        this.compressSpace = compressSpace;
    }

    @Override
    protected ReplacePatternLayoutEncoderBase.ReplacePattern getReplacePattern() {
        return JSON_REPLACE_PATTERN;
    }

    @Override
    protected ReplacePatternLayoutEncoderBase.Writer getWriter() {
        return this.writer;
    }

    private final class JsonWriter
    implements ReplacePatternLayoutEncoderBase.Writer {
        private JsonWriter() {
        }

        @Override
        public void write(Converter<ILoggingEvent> converter, ILoggingEvent event, StringBuilder buf) {
            try {
                int end;
                int start;
                if (converter instanceof ThrowableProxyConverter) {
                    if (event.getThrowableProxy() == null) {
                        return;
                    }
                    int closing = buf.lastIndexOf("}");
                    String closingStr = buf.substring(closing);
                    buf.delete(closing, buf.length()).append(",\"stacktrace\":\"");
                    start = buf.length();
                    converter.write(buf, (Object)event);
                    end = buf.length();
                    buf.append("\"");
                    buf.append(closingStr);
                } else {
                    start = buf.length();
                    converter.write(buf, (Object)event);
                    end = buf.length();
                }
                if (end == start) {
                    return;
                }
                if (FastJsonEncoder.this.compressSpace && converter instanceof LiteralConverter) {
                    int spaceStart = -1;
                    int spaceEnd = -1;
                    int spaceRemoved = 0;
                    boolean withinValue = false;
                    for (int i = start + 1; i < end - spaceRemoved; ++i) {
                        char c = buf.charAt(i);
                        if (!withinValue) {
                            boolean space;
                            boolean bl = space = c == '\r' || c == '\n' || c == ' ' || c == '\t';
                            if (spaceStart == -1 && space) {
                                spaceStart = i;
                            } else if (spaceStart >= 0 && !space) {
                                spaceEnd = i;
                            }
                            if (spaceEnd > spaceStart) {
                                buf.delete(spaceStart, spaceEnd);
                                spaceRemoved += spaceEnd - spaceStart;
                                spaceStart = -1;
                                spaceEnd = -1;
                            }
                        }
                        if (c != '\"' || buf.charAt(i - 1) == '\\') continue;
                        boolean bl = withinValue = !withinValue;
                        if (!withinValue) continue;
                        spaceStart = -1;
                        spaceEnd = -1;
                    }
                }
                if (converter instanceof DynamicConverter) {
                    FastJsonEncoder.this.replace(buf, start, end);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

