/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.plugins.udf.core;

import com.snowflake.plugins.udf.core.SnowflakeLogger;
import com.snowflake.plugins.udf.core.UserDefined;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;

public class Snowflake {
    private SnowflakeLogger sfLogger;
    private String artifactDirOnStage = "libs";
    private String dependencyDirOnStage = "dependency";
    private SnowflakeConnectionV1 conn;
    private Set<String> skippedDependencies = new HashSet<String>();
    private String stageName;
    private String artifactFileName;
    private Map<String, String> depsToStagePaths;

    public Snowflake(SnowflakeLogger logger, SnowflakeConnectionV1 conn, String stageName, String artifactFileName, Map<String, String> depsToStagePaths) {
        this.sfLogger = logger;
        this.conn = conn;
        this.stageName = this.normalizeStageLocation(stageName);
        this.artifactFileName = artifactFileName;
        this.depsToStagePaths = depsToStagePaths;
    }

    public void createStage() throws SQLException {
        this.sfLogger.info(String.format("Creating stage %s if not exists", this.stageName));
        this.conn.createStatement().execute(String.format("create stage if not exists %s", this.stageName));
        this.sfLogger.info("Stage located or created!");
    }

    public void uploadArtifact(String localFileName) throws SQLException {
        this.sfLogger.info("Uploading artifact JAR: " + localFileName);
        this.uploadFiles(localFileName, this.artifactDirOnStage, true);
        this.sfLogger.info("Artifact JAR uploaded!");
    }

    public void uploadDependencies(String localFilePath) throws SQLException {
        this.sfLogger.info("Uploading dependency JARs from: " + localFilePath);
        for (Map.Entry<String, String> entry : this.depsToStagePaths.entrySet()) {
            String dependencyFile = entry.getKey();
            String stagePath = entry.getValue();
            this.sfLogger.info("Uploading " + dependencyFile);
            String dependencyFilePath = String.format("%s/%s", localFilePath, dependencyFile);
            this.uploadDependencyIfExists(dependencyFilePath, stagePath, dependencyFile);
        }
        this.sfLogger.info("Dependency JARs uploaded!");
    }

    public void uploadDependencyIfExists(String dependencyFilePath, String stagePath, String dependencyFile) throws SQLException {
        if (new File(dependencyFilePath).isFile()) {
            this.uploadFiles(dependencyFilePath, stagePath, false);
        } else {
            this.skippedDependencies.add(dependencyFile);
            this.sfLogger.info(String.format("Dependency jar not found at %s. This is not a problem if the dependency was a platform/bill-of-materials dependency", dependencyFilePath));
        }
    }

    public void uploadFiles(String localFileName, String pathOnStage, boolean overwrite) throws SQLException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("AUTO_COMPRESS", "FALSE");
        options.put("PARALLEL", "4");
        options.put("OVERWRITE", String.valueOf(overwrite));
        String sql = String.format("PUT %s %s %s", this.normalizeLocalFile(localFileName), String.format("@%s/%s", this.stageName, pathOnStage), this.getOptionsStatement(options));
        this.conn.createStatement().execute(sql);
    }

    private String normalizeLocalFile(String file) {
        String trimFile = file.trim();
        if (trimFile.startsWith("file://") || this.isSingleQuoted(trimFile)) {
            return trimFile;
        }
        return "file://" + trimFile;
    }

    private boolean isSingleQuoted(String name) {
        return name.startsWith("'") && name.endsWith("'");
    }

    private String getOptionsStatement(Map<String, String> options) {
        StringBuilder statement = new StringBuilder();
        for (Map.Entry<String, String> option : options.entrySet()) {
            statement.append(String.format("%s = %s ", option.getKey(), option.getValue()));
        }
        return statement.toString().trim();
    }

    public String getImportString() {
        String artifact = this.artifactDirOnStage + "/" + this.artifactFileName;
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(artifact);
        for (Map.Entry<String, String> entry : this.depsToStagePaths.entrySet()) {
            String dependencyFile = entry.getKey();
            String stagePath = entry.getValue();
            if (this.skippedDependencies.contains(dependencyFile)) continue;
            imports.add(stagePath + "/" + dependencyFile);
        }
        ArrayList<String> importPaths = new ArrayList<String>();
        for (String s : imports) {
            importPaths.add(String.format("'@%s/%s'", this.stageName, s));
        }
        return String.join((CharSequence)", ", importPaths);
    }

    public String getPackageString(String udxType) {
        if (udxType.equals("procedure")) {
            return "PACKAGES = ('com.snowflake:snowpark:latest')\n";
        }
        return "";
    }

    public void createFunctionOrProc(UserDefined udx) throws SQLException {
        String s = String.format("CREATE OR REPLACE %s %s (%s)\n", udx.getType(), udx.getName(), udx.getInputs()) + String.format("RETURNS %s\n", udx.getReturns()) + "LANGUAGE java\n" + this.getPackageString(udx.getType()) + String.format("HANDLER = '%s'\n", udx.getHandler()) + String.format("IMPORTS = (%s);", this.getImportString());
        this.sfLogger.info("Running create function statement: ");
        this.sfLogger.info(s);
        this.conn.createStatement().execute(s);
    }

    private String normalizeStageLocation(String name) {
        String trimName = name.trim();
        if (trimName.startsWith("@")) {
            return trimName.substring(1);
        }
        return trimName;
    }
}

