/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.plugins.udf.core;

import com.snowflake.plugins.udf.core.Snowflake;
import com.snowflake.plugins.udf.core.SnowflakeLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;

public class SnowflakeBuilder {
    public Map<String, String> options = new HashMap<String, String>();
    public String url;
    private String stageName;
    private String artifactFileName;
    private Map<String, String> depsToStagePaths;
    private SnowflakeLogger sfLogger;

    public SnowflakeBuilder(SnowflakeLogger l) {
        this.sfLogger = l;
    }

    public SnowflakeBuilder config(String key, String val) {
        if (val != null) {
            if ((key = key.toLowerCase()).equals("url")) {
                this.url = this.formatUrl(val);
            } else {
                this.options.put(key, val);
            }
        }
        return this;
    }

    public SnowflakeBuilder config(Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            this.config(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public SnowflakeBuilder configFile(String filepath) throws IOException {
        Properties temp = new Properties();
        temp.load(new FileInputStream(filepath));
        for (Map.Entry<Object, Object> entry : temp.entrySet()) {
            this.config(entry.getKey().toString(), entry.getValue().toString());
        }
        return this;
    }

    public SnowflakeBuilder stageName(String stageName) {
        this.stageName = stageName;
        return this;
    }

    public SnowflakeBuilder artifactFileName(String artifactFileName) {
        this.artifactFileName = artifactFileName;
        return this;
    }

    public SnowflakeBuilder depsToStagePaths(Map<String, String> depsToStagePaths) {
        this.depsToStagePaths = depsToStagePaths;
        return this;
    }

    public Snowflake create() throws SQLException {
        if (this.url == null) {
            throw new IllegalArgumentException("'url' field missing from auth properties. Add your Snowflake url to continue");
        }
        Properties prop = this.jdbcConfig(this.options);
        this.sfLogger.info("Creating connection to snowflake at url: " + this.url);
        SnowflakeConnectionV1 conn = new SnowflakeConnectionV1(this.url, prop);
        this.sfLogger.info("Snowflake Session established!");
        return new Snowflake(this.sfLogger, conn, this.stageName, this.artifactFileName, this.depsToStagePaths);
    }

    private String formatUrl(String url) {
        String urlWithPort;
        if (!(url = url.trim()).matches(urlWithPort = "^.+:\\d+$")) {
            url = url + ":443";
        }
        return "jdbc:snowflake://" + url;
    }

    private Properties jdbcConfig(Map<String, String> options) {
        Properties config = new Properties();
        String client_memory_limit = "client_memory_limit";
        config.put(client_memory_limit, "10240");
        for (Map.Entry<String, String> option : options.entrySet()) {
            config.put(option.getKey(), option.getValue());
        }
        config.put("CLIENT_VALIDATE_DEFAULT_PARAMETERS", (Object)true);
        config.put("CLIENT_SESSION_KEEP_ALIVE", (Object)true);
        this.sfLogger.info(String.format("set JDBC client memory limit to %s", config.get(client_memory_limit)));
        return config;
    }
}

