/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.plugins.udf.maven;

import java.util.ArrayList;

public class Arg {
    public String name;
    public String type;

    public String toString() {
        return this.name + " " + this.type;
    }

    public boolean hasNull() {
        return this.name == null || this.type == null;
    }

    public static Arg[] fromString(String argsString) {
        if (argsString == null) {
            throw new IllegalArgumentException("The arguments of the function/procedure are missing. If there are no arguments, supply an empty string.");
        }
        if (argsString.length() == 0) {
            return new Arg[0];
        }
        String[] stringArgs = argsString.split(",");
        ArrayList<Arg> result = new ArrayList<Arg>();
        for (String stringArg : stringArgs) {
            String[] stringArgSplit = (stringArg = stringArg.trim()).split(" +");
            if (stringArgSplit.length != 2) {
                throw new IllegalArgumentException(String.format("Malformed argument: %s, from args: %s", stringArg, argsString));
            }
            Arg arg = new Arg();
            arg.name = stringArgSplit[0];
            arg.type = stringArgSplit[1];
            result.add(arg);
        }
        return result.toArray(new Arg[result.size()]);
    }
}

