/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.plugins.udf.maven;

import com.snowflake.plugins.udf.core.Snowflake;
import com.snowflake.plugins.udf.core.SnowflakeBuilder;
import com.snowflake.plugins.udf.maven.Function;
import com.snowflake.plugins.udf.maven.Procedure;
import com.snowflake.plugins.udf.maven.UserDefined;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.DEPLOY, requiresDependencyResolution=ResolutionScope.TEST)
public class DeployGoal
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="deploy.stage", required=true)
    private String stage;
    @Parameter(property="deploy.functions")
    private Function[] functions;
    @Parameter(property="deploy.procedures")
    private Procedure[] procedures;
    @Parameter(property="deploy.auth")
    private Map<String, String> auth;
    @Parameter(property="deploy.auth.url")
    private String auth_url;
    @Parameter(property="deploy.auth.user")
    private String auth_user;
    @Parameter(property="deploy.auth.password")
    private String auth_password;
    @Parameter(property="deploy.auth.role")
    private String auth_role;
    @Parameter(property="deploy.auth.db")
    private String auth_db;
    @Parameter(property="deploy.auth.schema")
    private String auth_schema;
    @Parameter(property="deploy.type")
    private String udx_type;
    @Parameter(property="deploy.name")
    private String udx_name;
    @Parameter(property="deploy.handler")
    private String udx_handler;
    @Parameter(property="deploy.returns")
    private String udx_returns;
    @Parameter(property="deploy.args")
    private String udx_args;
    private String dependencyDirName = "dependency";
    private String authFileParamName = "propertiesFile";
    private String buildDirectory;
    private List<UserDefined> udxs;
    private Snowflake snowflake;
    private String dependencyListFile;

    public void execute() throws MojoExecutionException {
        MojoExecutor.ExecutionEnvironment executionEnv = new MojoExecutor.ExecutionEnvironment(this.mavenProject, this.mavenSession, this.pluginManager);
        String artifactFileName = this.mavenProject.getBuild().getFinalName() + ".jar";
        this.buildDirectory = this.mavenProject.getBuild().getDirectory();
        this.dependencyListFile = String.format("%s/%s/dependencies.log", this.buildDirectory, this.dependencyDirName);
        this.udxs = Stream.concat(Arrays.stream(this.functions), Arrays.stream(this.procedures)).collect(Collectors.toList());
        this.appendCliUdxIfDefined(this.udxs);
        this.validateUserConfig();
        this.getLog().info((CharSequence)("Execute copy dependencies. Destination: " + this.buildDirectory + "/" + this.dependencyDirName));
        this.executeDependencyCopyDependencies(executionEnv);
        this.executeDependencyList(executionEnv);
        SnowflakeBuilder builder = new SnowflakeBuilder(arg_0 -> ((Log)this.getLog()).info(arg_0));
        this.configureSnowflakeAuth(builder);
        this.configureSnowflakeDeployParams(builder, this.stage, artifactFileName);
        try {
            this.snowflake = builder.create();
        }
        catch (SQLException e) {
            throw new MojoExecutionException("Error creating JDBC connection to snowflake. You likely need to change/add information to your auth config for the plugin: ", (Exception)e);
        }
        try {
            this.snowflake.createStage();
        }
        catch (SQLException e) {
            throw new MojoExecutionException("Error creating or accessing stage: ", (Exception)e);
        }
        try {
            this.snowflake.uploadArtifact(String.format("%s/%s", this.buildDirectory, artifactFileName));
            this.snowflake.uploadDependencies(String.format("%s/%s", this.buildDirectory, this.dependencyDirName));
        }
        catch (SQLException e) {
            throw new MojoExecutionException("Error uploading: ", (Exception)e);
        }
        try {
            for (UserDefined udf : this.udxs) {
                this.snowflake.createFunctionOrProc(udf);
            }
        }
        catch (SQLException e) {
            throw new MojoExecutionException("Error creating function or procedure.", (Exception)e);
        }
        this.getLog().info((CharSequence)"Functions created!");
    }

    private void validateUserConfig() {
        Properties properties;
        String compilerConfig;
        if (this.udxs.size() == 0) {
            throw new IllegalArgumentException("At least one function or procedure must be specified");
        }
        for (UserDefined udx : this.udxs) {
            udx.throwIfNull();
        }
        String java17Warning = "Java 17 is not supported for the Snowflake UDX plugin and will likely cause errors. Your compiler release or target version is set to 17";
        Plugin compiler = this.mavenProject.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (compiler != null && compiler.getConfiguration() != null && ((compilerConfig = compiler.getConfiguration().toString()).contains("<release>17</release>") || compilerConfig.contains("<target>17</target>"))) {
            this.getLog().warn((CharSequence)java17Warning);
        }
        if ((properties = this.mavenProject.getProperties()).getProperty("maven.compiler.release") != null && properties.getProperty("maven.compiler.release").contains("17") || properties.getProperty("maven.compiler.target") != null && properties.getProperty("maven.compiler.target").contains("17")) {
            this.getLog().warn((CharSequence)java17Warning);
        }
    }

    private void configureSnowflakeAuth(SnowflakeBuilder builder) throws MojoExecutionException {
        if (this.auth != null) {
            if (this.auth.containsKey(this.authFileParamName)) {
                this.getLog().info((CharSequence)("Reading auth config from file: " + this.auth.get(this.authFileParamName)));
                try {
                    builder.configFile(this.auth.get(this.authFileParamName));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading or accessing the specified properties file: ", (Exception)e);
                }
            }
            builder.config(this.auth);
        }
        HashMap<String, String> authCliParams = new HashMap<String, String>();
        authCliParams.put("url", this.auth_url);
        authCliParams.put("user", this.auth_user);
        authCliParams.put("password", this.auth_password);
        authCliParams.put("role", this.auth_role);
        authCliParams.put("db", this.auth_db);
        authCliParams.put("schema", this.auth_schema);
        builder.config(authCliParams);
    }

    private void configureSnowflakeDeployParams(SnowflakeBuilder builder, String stageName, String artifactFileName) throws MojoExecutionException {
        builder.stageName(stageName);
        builder.artifactFileName(artifactFileName);
        try {
            builder.depsToStagePaths(this.mapDependenciesToStagePaths());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendCliUdxIfDefined(List<UserDefined> udfs) {
        HashSet<String> udxCliParams = new HashSet<String>();
        udxCliParams.add(this.udx_type);
        udxCliParams.add(this.udx_name);
        udxCliParams.add(this.udx_args);
        udxCliParams.add(this.udx_handler);
        udxCliParams.add(this.udx_returns);
        for (String udxCliParam : udxCliParams) {
            if (udxCliParam == null) continue;
            UserDefined udx = UserDefined.create(this.udx_type, this.udx_name, this.udx_args, this.udx_handler, this.udx_returns);
            udfs.add(udx);
            break;
        }
    }

    private void executeDependencyCopyDependencies(MojoExecutor.ExecutionEnvironment executionEnv) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"3.5.0")), (String)MojoExecutor.goal((String)"copy-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"includeScope"), (String)"compile"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.buildDirectory + "/" + this.dependencyDirName))}), (MojoExecutor.ExecutionEnvironment)executionEnv);
    }

    private void executeDependencyList(MojoExecutor.ExecutionEnvironment executionEnv) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"3.5.0")), (String)MojoExecutor.goal((String)"list"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"includeScope"), (String)"compile"), MojoExecutor.element((String)MojoExecutor.name((String)"outputFile"), (String)this.dependencyListFile), MojoExecutor.element((String)MojoExecutor.name((String)"outputAbsoluteArtifactFilename"), (String)"true")}), (MojoExecutor.ExecutionEnvironment)executionEnv);
    }

    private Map<String, String> mapDependenciesToStagePaths() throws MojoExecutionException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String fileNames = "[^/]*\\.jar";
        Pattern pattern = Pattern.compile(fileNames);
        try (LineIterator it = FileUtils.lineIterator((File)new File(this.dependencyListFile), (String)"UTF-8");){
            it = FileUtils.lineIterator((File)new File(this.dependencyListFile), (String)"UTF-8");
            while (it.hasNext()) {
                String line = it.nextLine().trim();
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String fileName = matcher.group();
                String[] info = line.split(":");
                String groupId = info[0];
                String artifactId = info[1];
                String version = info[3];
                String stagePath = String.format("%s/%s/%s", groupId.replace('.', '/'), artifactId, version);
                result.put(fileName, stagePath);
            }
        }
        this.getLog().info((CharSequence)("Mapped dependencies to stage paths: " + ((Object)result).toString()));
        return result;
    }
}

