/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.plugins.udf.maven;

import com.snowflake.plugins.udf.maven.Arg;
import com.snowflake.plugins.udf.maven.Function;
import com.snowflake.plugins.udf.maven.Procedure;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class UserDefined
implements com.snowflake.plugins.udf.core.UserDefined {
    public static final String procedure = "procedure";
    public static final String function = "function";
    public String name;
    public String handler;
    public String returns;
    public Arg[] args;

    @Override
    public abstract String getType();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public String getReturns() {
        return this.returns;
    }

    public static UserDefined create(String type, String name, String args, String handler, String returns) {
        UserDefined udx;
        if (type == null) {
            throw new IllegalArgumentException("The type of the user defined creation must be specified. Type may be \"procedure\" or \"function\"");
        }
        switch (type.toLowerCase()) {
            case "procedure": {
                udx = new Procedure();
                break;
            }
            case "function": {
                udx = new Function();
                break;
            }
            default: {
                throw new IllegalArgumentException("The specified type is not recognized. The type of the user defined creation may be \"procedure\" or \"function\"");
            }
        }
        udx.name = name;
        udx.handler = handler;
        udx.returns = returns;
        udx.args = Arg.fromString(args);
        return udx;
    }

    @Override
    public String getInputs() {
        return String.join((CharSequence)", ", Arrays.stream(this.args).map(arg -> arg.toString()).collect(Collectors.toList()));
    }

    public void throwIfNull() {
        if (this.name == null) {
            throw new IllegalArgumentException("name not defined");
        }
        if (this.handler == null) {
            throw new IllegalArgumentException("handler not defined");
        }
        if (this.returns == null) {
            throw new IllegalArgumentException("returns not defined");
        }
        if (this.args == null) {
            throw new IllegalArgumentException("args not defined");
        }
        for (Arg arg : this.args) {
            if (!arg.hasNull()) continue;
            throw new IllegalArgumentException("malformed arg");
        }
    }
}

