/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.DataFrame$;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.SnowparkClientException;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.analyzer.ExprId;
import com.snowflake.snowpark.internal.analyzer.LogicalPlan;
import com.snowflake.snowpark.internal.analyzer.Query;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import java.io.Serializable;
import java.util.Locale;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class SnowflakePlan$
extends Logging {
    public static SnowflakePlan$ MODULE$;
    private final HashSet<String> CopyOption;

    static {
        new SnowflakePlan$();
    }

    public SnowflakePlan apply(Seq<Query> queries, String schemaQuery, Session session, Option<LogicalPlan> sourcePlan, boolean supportAsyncMode) {
        return new SnowflakePlan(queries, schemaQuery, (Seq<Query>)((Seq)Seq$.MODULE$.empty()), (Map<ExprId, String>)Predef$.MODULE$.Map().empty(), session, sourcePlan, supportAsyncMode);
    }

    public SnowflakePlan apply(Seq<Query> queries, String schemaQuery, Seq<Query> postActions, Map<ExprId, String> exprToAlias, Session session, Option<LogicalPlan> sourcePlan, boolean supportAsyncMode) {
        return new SnowflakePlan(queries, schemaQuery, postActions, exprToAlias, session, sourcePlan, supportAsyncMode);
    }

    public <T> T wrapException(Seq<SnowflakePlan> children, Function0<T> thunk) {
        Object object;
        try {
            object = thunk.apply();
        }
        catch (Throwable throwable) {
            boolean bl = false;
            SnowflakeSQLException snowflakeSQLException = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SnowflakeSQLException) {
                bl = true;
                snowflakeSQLException = (SnowflakeSQLException)throwable2;
                if (snowflakeSQLException.getMessage().toLowerCase(Locale.ROOT).contains("unexpected 'as'")) {
                    SnowparkClientException newEx = ErrorMessage$.MODULE$.PLAN_JDBC_REPORT_UNEXPECTED_ALIAS();
                    newEx.initCause(snowflakeSQLException);
                    throw newEx;
                }
            }
            if (bl) {
                String string = snowflakeSQLException.getSQLState();
                String string2 = "42000";
                if (!(string != null ? !string.equals(string2) : string2 != null) && snowflakeSQLException.getMessage().contains("invalid identifier")) {
                    String colName2;
                    String string3;
                    Regex ColPattern = new StringOps(Predef$.MODULE$.augmentString("(?s).*invalid identifier '\"?([^'\"]*)\"?'.*")).r();
                    Option option = ColPattern.unapplySeq((CharSequence)(string3 = snowflakeSQLException.getMessage()));
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                        throw snowflakeSQLException;
                    }
                    String string4 = colName2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String col = string4;
                    Seq remapped = (Seq)((TraversableLike)children.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.exprToAlias().values(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replaceAll("^\"|\"$", ""), Seq$.MODULE$.canBuildFrom());
                    if (remapped.count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.equals(col))) > 0) {
                        String origColName = (String)DataFrame$.MODULE$.getUnaliased(col).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> "<colname>");
                        SnowparkClientException newEx = ErrorMessage$.MODULE$.PLAN_JDBC_REPORT_INVALID_ID(origColName);
                        newEx.initCause(snowflakeSQLException);
                        throw newEx;
                    }
                    if (((TraversableOnce)remapped.flatMap((Function1 & Serializable & scala.Serializable)colName -> DataFrame$.MODULE$.getUnaliased((String)colName), Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.equals(col))) > 1) {
                        SnowparkClientException newEx = ErrorMessage$.MODULE$.PLAN_JDBC_REPORT_JOIN_AMBIGUOUS(col, col);
                        newEx.initCause(snowflakeSQLException);
                        throw newEx;
                    }
                    throw snowflakeSQLException;
                }
            }
            throw throwable;
        }
        return (T)object;
    }

    public HashSet<String> CopyOption() {
        return this.CopyOption;
    }

    private SnowflakePlan$() {
        MODULE$ = this;
        this.CopyOption = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ON_ERROR", "SIZE_LIMIT", "PURGE", "RETURN_FAILED_ONLY", "MATCH_BY_COLUMN_NAME", "ENFORCE_LENGTH", "TRUNCATECOLUMNS", "FORCE", "LOAD_UNCERTAIN_FILES"}));
    }
}

