/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.analyzer.Analyzer$;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.Attribute$;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import com.snowflake.snowpark.internal.analyzer.package$;
import com.snowflake.snowpark.types.StructType;
import com.snowflake.snowpark.types.VariantType$;
import java.io.Serializable;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]g!B\u0016-\u0001A2\u0004\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011A\u001f\t\u0011\t\u0003!\u0011!Q\u0001\nyB\u0001b\u0011\u0001\u0003\u0002\u0004%\t\u0001\u0012\u0005\t+\u0002\u0011\t\u0019!C\u0001-\"AQ\f\u0001B\u0001B\u0003&Q\t\u0003\u0005_\u0001\t\u0005\r\u0011\"\u0001`\u0011!\u0001\u0007A!a\u0001\n\u0003\t\u0007\u0002C2\u0001\u0005\u0003\u0005\u000b\u0015\u0002*\t\u0011\u0011\u0004!\u00111A\u0005\u0002}C\u0001\"\u001a\u0001\u0003\u0002\u0004%\tA\u001a\u0005\tQ\u0002\u0011\t\u0011)Q\u0005%\"A\u0011\u000e\u0001BA\u0002\u0013\u0005q\f\u0003\u0005k\u0001\t\u0005\r\u0011\"\u0001l\u0011!i\u0007A!A!B\u0013\u0011\u0006\u0002\u00038\u0001\u0005\u0003\u0007I\u0011A8\t\u0011e\u0004!\u00111A\u0005\u0002iD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006K\u0001\u001d\u0005\t{\u0002\u0011\t\u0019!C\u0001}\"Q\u0011\u0011\u0001\u0001\u0003\u0002\u0004%\t!a\u0001\t\u0013\u0005\u001d\u0001A!A!B\u0013y\bBCA\u0005\u0001\t\u0005\r\u0011\"\u0001\u0002\f!Q\u0011q\u0004\u0001\u0003\u0002\u0004%\t!!\t\t\u0015\u0005\u0015\u0002A!A!B\u0013\ti\u0001\u0003\u0006\u0002(\u0001\u0011\t\u0019!C\u0001\u0003SA!\"!\u000e\u0001\u0005\u0003\u0007I\u0011AA\u001c\u0011)\tY\u0004\u0001B\u0001B\u0003&\u00111\u0006\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\ti\u0004\u0001C\u0001\u0003+Bq!!\u0010\u0001\t\u0003\tI\u0006C\u0005\u0002`\u0001\u0011\r\u0011\"\u0004\u0002b!A\u0011\u0011\u0011\u0001!\u0002\u001b\t\u0019\u0007C\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCaA\u001c\u0001\u0005\u0002\u0005e\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003\u0013\u0001A\u0011AAc\u0011\u001d\t9\u0003\u0001C\u0001\u0003\u0013Dq!!4\u0001\t\u0003\tyM\u0001\tTi\u0006<W\r\u001a$jY\u0016\u0014V-\u00193fe*\u0011QFL\u0001\tC:\fG.\u001f>fe*\u0011q\u0006M\u0001\tS:$XM\u001d8bY*\u0011\u0011GM\u0001\tg:|w\u000f]1sW*\u00111\u0007N\u0001\ng:|wO\u001a7bW\u0016T\u0011!N\u0001\u0004G>l7C\u0001\u00018!\tA\u0014(D\u0001/\u0013\tQdFA\u0004M_\u001e<\u0017N\\4\u0002\u000fM,7o]5p]\u000e\u0001Q#\u0001 \u0011\u0005}\u0002U\"\u0001\u0019\n\u0005\u0005\u0003$aB*fgNLwN\\\u0001\tg\u0016\u001c8/[8oA\u0005Q1-\u001e:PaRLwN\\:\u0016\u0003\u0015\u0003BAR(S%:\u0011q)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015r\na\u0001\u0010:p_Rt$\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[\u0015A\u0002)sK\u0012,g-\u0003\u0002Q#\n\u0019Q*\u00199\u000b\u00059[\u0005C\u0001$T\u0013\t!\u0016K\u0001\u0004TiJLgnZ\u0001\u000fGV\u0014x\n\u001d;j_:\u001cx\fJ3r)\t96\f\u0005\u0002Y36\t1*\u0003\u0002[\u0017\n!QK\\5u\u0011\u001daF!!AA\u0002\u0015\u000b1\u0001\u001f\u00132\u0003-\u0019WO](qi&|gn\u001d\u0011\u0002\u001bM$\u0018mZ3M_\u000e\fG/[8o+\u0005\u0011\u0016!E:uC\u001e,Gj\\2bi&|gn\u0018\u0013fcR\u0011qK\u0019\u0005\b9\u001e\t\t\u00111\u0001S\u00039\u0019H/Y4f\u0019>\u001c\u0017\r^5p]\u0002\n!BZ8s[\u0006$H+\u001f9f\u000391wN]7biRK\b/Z0%KF$\"aV4\t\u000fqS\u0011\u0011!a\u0001%\u0006Yam\u001c:nCR$\u0016\u0010]3!\u0003Q1W\u000f\u001c7z#V\fG.\u001b4jK\u0012\u001c6\r[3nC\u0006Ab-\u001e7msF+\u0018\r\\5gS\u0016$7k\u00195f[\u0006|F%Z9\u0015\u0005]c\u0007b\u0002/\u000e\u0003\u0003\u0005\rAU\u0001\u0016MVdG._)vC2Lg-[3e'\u000eDW-\\1!\u0003))8/\u001a:TG\",W.Y\u000b\u0002aB\u0019\u0001,]:\n\u0005I\\%AB(qi&|g\u000e\u0005\u0002uo6\tQO\u0003\u0002wa\u0005)A/\u001f9fg&\u0011\u00010\u001e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017AD;tKJ\u001c6\r[3nC~#S-\u001d\u000b\u0003/nDq\u0001\u0018\t\u0002\u0002\u0003\u0007\u0001/A\u0006vg\u0016\u00148k\u00195f[\u0006\u0004\u0013!\u0003;bE2,g*Y7f+\u0005y\bc\u0001-r%\u0006iA/\u00192mK:\u000bW.Z0%KF$2aVA\u0003\u0011\u001da6#!AA\u0002}\f!\u0002^1cY\u0016t\u0015-\\3!\u0003-\u0019w\u000e\\;n]:\u000bW.Z:\u0016\u0005\u00055\u0001#BA\b\u00033\u0011f\u0002BA\t\u0003+q1\u0001SA\n\u0013\u0005a\u0015bAA\f\u0017\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u00111aU3r\u0015\r\t9bS\u0001\u0010G>dW/\u001c8OC6,7o\u0018\u0013fcR\u0019q+a\t\t\u0011q3\u0012\u0011!a\u0001\u0003\u001b\tAbY8mk6tg*Y7fg\u0002\nq\u0002\u001e:b]N4wN]7bi&|gn]\u000b\u0003\u0003W\u0001b!a\u0004\u0002\u001a\u00055\u0002\u0003BA\u0018\u0003ci\u0011\u0001L\u0005\u0004\u0003ga#AC#yaJ,7o]5p]\u0006\u0019BO]1og\u001a|'/\\1uS>t7o\u0018\u0013fcR\u0019q+!\u000f\t\u0011qK\u0012\u0011!a\u0001\u0003W\t\u0001\u0003\u001e:b]N4wN]7bi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)Q\t\t%a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny%!\u0015\u0002TA\u0019\u0011q\u0006\u0001\t\u000bmZ\u0002\u0019\u0001 \t\u000b\r[\u0002\u0019A#\t\u000by[\u0002\u0019\u0001*\t\u000b\u0011\\\u0002\u0019\u0001*\t\u000b%\\\u0002\u0019\u0001*\t\u000b9\\\u0002\u0019\u00019\t\u000bu\\\u0002\u0019A@\t\u000f\u0005%1\u00041\u0001\u0002\u000e!9\u0011qE\u000eA\u0002\u0005-B\u0003BA!\u0003/BQa\u000f\u000fA\u0002y\"B!!\u0011\u0002\\!9\u0011QL\u000fA\u0002\u0005\u0005\u0013\u0001E:uC\u001e,GMR5mKJ+\u0017\rZ3s\u0003I\u0019X\u000f\u001d9peR,GMR5mKRK\b/Z:\u0016\u0005\u0005\r\u0004CBA3\u0003_\n\u0019(\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003%IW.\\;uC\ndWMC\u0002\u0002n-\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t(a\u001a\u0003\u0007M+G\u000f\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\nAA[1wC&\u0019A+a\u001e\u0002'M,\b\u000f]8si\u0016$g)\u001b7f)f\u0004Xm\u001d\u0011\u0002\tA\fG\u000f\u001b\u000b\u0005\u0003\u0003\n9\tC\u0003_A\u0001\u0007!+\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0005\u0003\u0003\ni\tC\u0003eC\u0001\u0007!+\u0001\u0004paRLwN\u001c\u000b\u0007\u0003\u0003\n\u0019*a&\t\r\u0005U%\u00051\u0001S\u0003\rYW-\u001f\u0005\b\u00033\u0013\u0003\u0019AAN\u0003\u00151\u0018\r\\;f!\rA\u0016QT\u0005\u0004\u0003?[%aA!os\u0006Q\u0001/\u0019:tKZ\u000bG.^3\u0015\u0007I\u000b)\u000bC\u0004\u0002(\u000e\u0002\r!a'\u0002\u0003Y\fqa\u001c9uS>t7\u000f\u0006\u0003\u0002B\u00055\u0006bBAXI\u0001\u0007\u0011\u0011W\u0001\bG>tg-[4t!\u00151uJUAN\u00039!\u0017\r^1cCN,7k\u00195f[\u0006$B!!\u0011\u00028\")\u0011.\na\u0001%R!\u0011\u0011IA^\u0011\u0019\tiL\na\u0001g\u000611o\u00195f[\u0006\fQ\u0001^1cY\u0016$B!!\u0011\u0002D\")Qp\na\u0001%R!\u0011\u0011IAd\u0011\u001d\tI\u0001\u000ba\u0001\u0003\u001b!B!!\u0011\u0002L\"9\u0011qE\u0015A\u0002\u0005-\u0012aE2sK\u0006$Xm\u00158po\u001ad\u0017m[3QY\u0006tGCAAi!\u0011\ty#a5\n\u0007\u0005UGFA\u0007T]><h\r\\1lKBc\u0017M\u001c")
public class StagedFileReader
extends Logging {
    private final Session session;
    private Map<String, String> curOptions;
    private String stageLocation;
    private String formatType;
    private String fullyQualifiedSchema;
    private Option<StructType> userSchema;
    private Option<String> tableName;
    private Seq<String> columnNames;
    private Seq<Expression> transformations;
    private final Set<String> supportedFileTypes;

    public Session session() {
        return this.session;
    }

    public Map<String, String> curOptions() {
        return this.curOptions;
    }

    public void curOptions_$eq(Map<String, String> x$1) {
        this.curOptions = x$1;
    }

    public String stageLocation() {
        return this.stageLocation;
    }

    public void stageLocation_$eq(String x$1) {
        this.stageLocation = x$1;
    }

    public String formatType() {
        return this.formatType;
    }

    public void formatType_$eq(String x$1) {
        this.formatType = x$1;
    }

    public String fullyQualifiedSchema() {
        return this.fullyQualifiedSchema;
    }

    public void fullyQualifiedSchema_$eq(String x$1) {
        this.fullyQualifiedSchema = x$1;
    }

    public Option<StructType> userSchema() {
        return this.userSchema;
    }

    public void userSchema_$eq(Option<StructType> x$1) {
        this.userSchema = x$1;
    }

    public Option<String> tableName() {
        return this.tableName;
    }

    public void tableName_$eq(Option<String> x$1) {
        this.tableName = x$1;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    public void columnNames_$eq(Seq<String> x$1) {
        this.columnNames = x$1;
    }

    public Seq<Expression> transformations() {
        return this.transformations;
    }

    public void transformations_$eq(Seq<Expression> x$1) {
        this.transformations = x$1;
    }

    private final Set<String> supportedFileTypes() {
        return this.supportedFileTypes;
    }

    public StagedFileReader path(String stageLocation) {
        this.stageLocation_$eq(stageLocation);
        return this;
    }

    public StagedFileReader format(String formatType) {
        String upperFormatType = formatType.toUpperCase(Locale.ROOT);
        if (!this.supportedFileTypes().contains((Object)upperFormatType)) {
            throw ErrorMessage$.MODULE$.PLAN_UNSUPPORTED_FILE_FORMAT_TYPE(formatType);
        }
        this.formatType_$eq(upperFormatType);
        return this;
    }

    public StagedFileReader option(String key, Object value) {
        this.curOptions_$eq((Map<String, String>)this.curOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toUpperCase(Locale.ROOT)), (Object)this.parseValue(value))));
        return this;
    }

    private String parseValue(Object v) {
        String string;
        Object object = v;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            string = ((Object)BoxesRunTime.boxToBoolean((boolean)bl)).toString();
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            string = ((Object)BoxesRunTime.boxToInteger((int)n)).toString();
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            string = n.toString();
        } else {
            String string2;
            string = object instanceof String && ((string2 = (String)object).equalsIgnoreCase("true") || string2.equalsIgnoreCase("false")) ? string2 : package$.MODULE$.singleQuote(v.toString());
        }
        return string;
    }

    public StagedFileReader options(Map<String, Object> configs) {
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            StagedFileReader stagedFileReader = this.option(k, v);
            return stagedFileReader;
        });
        return this;
    }

    public StagedFileReader databaseSchema(String fullyQualifiedSchema) {
        this.fullyQualifiedSchema_$eq(fullyQualifiedSchema);
        return this;
    }

    public StagedFileReader userSchema(StructType schema) {
        this.userSchema_$eq((Option<StructType>)new Some((Object)schema));
        return this;
    }

    public StagedFileReader table(String tableName) {
        this.tableName_$eq((Option<String>)new Some((Object)tableName));
        return this;
    }

    public StagedFileReader columnNames(Seq<String> columnNames) {
        this.columnNames_$eq(columnNames);
        return this;
    }

    public StagedFileReader transformations(Seq<Expression> transformations) {
        this.transformations_$eq(transformations);
        return this;
    }

    public SnowflakePlan createSnowflakePlan() {
        SnowflakePlan snowflakePlan;
        if (this.tableName().nonEmpty()) {
            snowflakePlan = this.session().plans().copyInto((String)this.tableName().get(), this.stageLocation(), this.formatType(), this.curOptions(), this.fullyQualifiedSchema(), this.columnNames(), (Seq<String>)((Seq)this.transformations().map((Function1 & Serializable & scala.Serializable)expr -> Analyzer$.MODULE$.analyze((Expression)expr), Seq$.MODULE$.canBuildFrom())), this.userSchema());
        } else if (this.formatType().equals("CSV")) {
            if (this.userSchema().isEmpty()) {
                throw ErrorMessage$.MODULE$.DF_MUST_PROVIDE_SCHEMA_FOR_READING_FILE();
            }
            snowflakePlan = this.session().plans().readFile(this.stageLocation(), this.formatType(), this.curOptions(), this.fullyQualifiedSchema(), ((StructType)this.userSchema().get()).toAttributes());
        } else {
            Predef$.MODULE$.require(this.userSchema().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Read ").append(this.formatType()).append(" does not support user schema").toString());
            snowflakePlan = this.session().plans().readFile(this.stageLocation(), this.formatType(), this.curOptions(), this.fullyQualifiedSchema(), (Seq<Attribute>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{Attribute$.MODULE$.apply("\"$1\"", VariantType$.MODULE$)}))));
        }
        return snowflakePlan;
    }

    public StagedFileReader(Session session, Map<String, String> curOptions, String stageLocation, String formatType, String fullyQualifiedSchema, Option<StructType> userSchema, Option<String> tableName, Seq<String> columnNames, Seq<Expression> transformations) {
        this.session = session;
        this.curOptions = curOptions;
        this.stageLocation = stageLocation;
        this.formatType = formatType;
        this.fullyQualifiedSchema = fullyQualifiedSchema;
        this.userSchema = userSchema;
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.transformations = transformations;
        this.supportedFileTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSV", "JSON", "PARQUET", "AVRO", "ORC", "XML"}));
    }

    public StagedFileReader(Session session) {
        this(session, (Map<String, String>)Predef$.MODULE$.Map().empty(), "", "CSV", "", (Option<StructType>)None$.MODULE$, (Option<String>)None$.MODULE$, (Seq<String>)((Seq)Seq$.MODULE$.empty()), (Seq<Expression>)((Seq)Seq$.MODULE$.empty()));
    }

    public StagedFileReader(StagedFileReader stagedFileReader) {
        this(stagedFileReader.session(), stagedFileReader.curOptions(), stagedFileReader.stageLocation(), stagedFileReader.formatType(), stagedFileReader.fullyQualifiedSchema(), stagedFileReader.userSchema(), stagedFileReader.tableName(), stagedFileReader.columnNames(), stagedFileReader.transformations());
    }
}

