/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.CopyableDataFrame;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.types.InternalUtils;
import com.snowflake.snowpark_java.types.StructType;
import java.util.Map;

public class DataFrameReader {
    private final com.snowflake.snowpark.DataFrameReader reader;

    DataFrameReader(com.snowflake.snowpark.DataFrameReader reader) {
        this.reader = reader;
    }

    public DataFrame table(String name) {
        return new DataFrame(this.reader.table(name));
    }

    public DataFrameReader schema(StructType schema) {
        this.reader.schema(InternalUtils.toScalaStructType(schema));
        return this;
    }

    public CopyableDataFrame csv(String path) {
        return new CopyableDataFrame(this.reader.csv(path));
    }

    public CopyableDataFrame json(String path) {
        return new CopyableDataFrame(this.reader.json(path));
    }

    public CopyableDataFrame avro(String path) {
        return new CopyableDataFrame(this.reader.avro(path));
    }

    public CopyableDataFrame parquet(String path) {
        return new CopyableDataFrame(this.reader.parquet(path));
    }

    public CopyableDataFrame orc(String path) {
        return new CopyableDataFrame(this.reader.orc(path));
    }

    public CopyableDataFrame xml(String path) {
        return new CopyableDataFrame(this.reader.xml(path));
    }

    public DataFrameReader option(String key, Object value) {
        this.reader.option(key, value);
        return this;
    }

    public DataFrameReader options(Map<String, Object> configs) {
        this.reader.options(JavaUtils.javaStringMapToScala(configs));
        return this;
    }
}

