/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.Column;
import com.snowflake.snowpark_java.DataFrame;
import java.util.Map;
import java.util.Optional;
import scala.Option;

public class DataFrameStatFunctions {
    private final com.snowflake.snowpark.DataFrameStatFunctions func;

    DataFrameStatFunctions(com.snowflake.snowpark.DataFrameStatFunctions func) {
        this.func = func;
    }

    public Optional<Double> corr(String col1, String col2) {
        return DataFrameStatFunctions.toJavaOptional(this.func.corr(col1, col2));
    }

    public Optional<Double> cov(String col1, String col2) {
        return DataFrameStatFunctions.toJavaOptional(this.func.cov(col1, col2));
    }

    public Optional<Double>[] approxQuantile(String col, double[] percentile) {
        Option<Object>[] result = this.func.approxQuantile(col, percentile);
        Optional[] javaResult = new Optional[result.length];
        for (int i = 0; i < result.length; ++i) {
            javaResult[i] = DataFrameStatFunctions.toJavaOptional(result[i]);
        }
        return javaResult;
    }

    public Optional<Double>[][] approxQuantile(String[] cols, double[] percentile) {
        Option<Object>[][] result = this.func.approxQuantile(cols, percentile);
        Optional[][] javaResult = new Optional[result.length][];
        for (int i = 0; i < result.length; ++i) {
            javaResult[i] = new Optional[result[i].length];
            for (int j = 0; j < result[i].length; ++j) {
                javaResult[i][j] = DataFrameStatFunctions.toJavaOptional(result[i][j]);
            }
        }
        return javaResult;
    }

    public DataFrame crosstab(String col1, String col2) {
        return new DataFrame(this.func.crosstab(col1, col2));
    }

    public DataFrame sampleBy(Column col, Map<?, Double> fractions) {
        return new DataFrame(JavaUtils.sampleBy(col.toScalaColumn(), fractions, this.func));
    }

    public DataFrame sampleBy(String colName, Map<?, Double> fractions) {
        return new DataFrame(JavaUtils.sampleBy(colName, fractions, this.func));
    }

    private static Optional<Double> toJavaOptional(Option<Object> input) {
        if (input.isDefined()) {
            return Optional.of((Double)input.get());
        }
        return Optional.empty();
    }
}

