/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.Column;
import com.snowflake.snowpark_java.DataFrame;
import com.snowflake.snowpark_java.DataFrameReader;
import com.snowflake.snowpark_java.Row;
import com.snowflake.snowpark_java.SessionBuilder;
import com.snowflake.snowpark_java.UDFRegistration;
import com.snowflake.snowpark_java.Updatable;
import com.snowflake.snowpark_java.types.InternalUtils;
import com.snowflake.snowpark_java.types.StructType;
import java.net.URI;
import java.sql.Connection;
import java.util.Optional;
import java.util.Set;
import scala.Option;

public class Session {
    private final com.snowflake.snowpark.Session session;
    private UDFRegistration udf = null;

    Session(com.snowflake.snowpark.Session session) {
        this.session = session;
    }

    public static SessionBuilder builder() {
        return new SessionBuilder();
    }

    public DataFrame sql(String query) {
        return new DataFrame(this.session.sql(query));
    }

    public Updatable table(String name) {
        return new Updatable(this.session.table(name));
    }

    public Updatable table(String[] multipartIdentifier) {
        return new Updatable(this.session.table(multipartIdentifier));
    }

    public DataFrame range(long end) {
        return new DataFrame(this.session.range(end));
    }

    public DataFrame range(long start, long end, long step) {
        return new DataFrame(this.session.range(start, end, step));
    }

    public DataFrame range(long start, long end) {
        return new DataFrame(this.session.range(start, end));
    }

    public DataFrame createDataFrame(Row[] data, StructType schema) {
        com.snowflake.snowpark.Row[] scalaRows = new com.snowflake.snowpark.Row[data.length];
        for (int i = 0; i < data.length; ++i) {
            scalaRows[i] = data[i].getScalaRow();
        }
        return new DataFrame(this.session.createDataFrame(scalaRows, InternalUtils.toScalaStructType(schema)));
    }

    public UDFRegistration udf() {
        if (this.udf == null) {
            this.udf = new UDFRegistration(this.session.udf());
        }
        return this.udf;
    }

    public void removeDependency(String path) {
        this.session.removeDependency(path);
    }

    public void addDependency(String path) {
        this.session.addDependency(path);
    }

    public Set<URI> getDependencies() {
        return this.session.getDependenciesAsJavaSet();
    }

    public void cancelAll() {
        this.session.cancelAll();
    }

    public Connection jdbcConnection() {
        return this.session.jdbcConnection();
    }

    public void setQueryTag(String queryTag) {
        this.session.setQueryTag(queryTag);
    }

    public void unsetQueryTag() {
        this.session.unsetQueryTag();
    }

    public DataFrame generator(long rowCount, Column ... columns) {
        return new DataFrame(this.session.generator(rowCount, JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(columns))));
    }

    public Optional<String> getDefaultDataBase() {
        Option<String> result = this.session.getDefaultDatabase();
        if (result.isDefined()) {
            return Optional.of(result.get());
        }
        return Optional.empty();
    }

    public Optional<String> getDefaultSchema() {
        Option<String> result = this.session.getDefaultSchema();
        if (result.isDefined()) {
            return Optional.of(result.get());
        }
        return Optional.empty();
    }

    public Optional<String> getCurrentDataBase() {
        Option<String> result = this.session.getCurrentDatabase();
        if (result.isDefined()) {
            return Optional.of(result.get());
        }
        return Optional.empty();
    }

    public Optional<String> getCurrentSchema() {
        Option<String> result = this.session.getCurrentSchema();
        if (result.isDefined()) {
            return Optional.of(result.get());
        }
        return Optional.empty();
    }

    public String getFullyQualifiedCurrentSchema() {
        return this.session.getFullyQualifiedCurrentSchema();
    }

    public Optional<String> getQueryTag() {
        Option<String> result = this.session.getQueryTag();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(result.get());
    }

    public String getSessionStage() {
        return this.session.getSessionStage();
    }

    public DataFrame flatten(Column input) {
        return new DataFrame(this.session.flatten(input.toScalaColumn()));
    }

    public DataFrame flatten(Column input, String path, boolean outer, boolean recursive, String mode) {
        return new DataFrame(this.session.flatten(input.toScalaColumn(), path, outer, recursive, mode));
    }

    public void close() {
        this.session.close();
    }

    public String getSessionInfo() {
        return this.session.getSessionInfo();
    }

    public DataFrameReader read() {
        return new DataFrameReader(this.session.read());
    }

    com.snowflake.snowpark.Session getScalaSession() {
        return this.session;
    }
}

