/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.internal.Utils$;
import com.snowflake.snowpark.internal.analyzer.package$;
import com.snowflake.snowpark.types.ArrayType;
import com.snowflake.snowpark.types.BinaryType$;
import com.snowflake.snowpark.types.BooleanType$;
import com.snowflake.snowpark.types.ByteType$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.DateType$;
import com.snowflake.snowpark.types.DecimalType;
import com.snowflake.snowpark.types.DoubleType$;
import com.snowflake.snowpark.types.FloatType$;
import com.snowflake.snowpark.types.GeographyType$;
import com.snowflake.snowpark.types.IntegerType$;
import com.snowflake.snowpark.types.LongType$;
import com.snowflake.snowpark.types.MapType;
import com.snowflake.snowpark.types.NumericType;
import com.snowflake.snowpark.types.ShortType$;
import com.snowflake.snowpark.types.StringType$;
import com.snowflake.snowpark.types.StructType;
import com.snowflake.snowpark.types.TimeType$;
import com.snowflake.snowpark.types.TimestampType$;
import com.snowflake.snowpark.types.VariantType$;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;

public final class DataTypeMapper$ {
    public static DataTypeMapper$ MODULE$;
    private final long MILLIS_PER_DAY;
    private final long MICROS_PER_MILLIS;

    static {
        new DataTypeMapper$();
    }

    private long MILLIS_PER_DAY() {
        return this.MILLIS_PER_DAY;
    }

    private long MICROS_PER_MILLIS() {
        return this.MICROS_PER_MILLIS;
    }

    public String stringToSql(String str) {
        return new StringBuilder(2).append("'").append(str.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "''").replaceAll("\n", "\\\\n")).append("'").toString();
    }

    public String toSql(Object value, Option<DataType> dataType) {
        Option<DataType> option = dataType;
        if (None$.MODULE$.equals(option)) {
            return "NULL";
        }
        if (option instanceof Some) {
            DataType dataType2;
            DataType dataType3;
            DataType dataType4;
            DataType dataType5;
            DataType dataType6;
            DataType dataType7;
            DataType dataType8;
            DataType dataType9;
            DataType dataType10;
            DataType dataType11;
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            Tuple2 tuple2 = new Tuple2(value, (Object)dt);
            if (tuple2 != null && ((dataType11 = (DataType)tuple2._2()) instanceof ArrayType ? true : (dataType11 instanceof MapType ? true : (dataType11 instanceof StructType ? true : GeographyType$.MODULE$.equals(dataType11)))) && value == null) {
                return "NULL";
            }
            if (tuple2 != null && IntegerType$.MODULE$.equals(dataType10 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: int";
            }
            if (tuple2 != null && ShortType$.MODULE$.equals(dataType9 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: smallint";
            }
            if (tuple2 != null && ByteType$.MODULE$.equals(dataType8 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: tinyint";
            }
            if (tuple2 != null && LongType$.MODULE$.equals(dataType7 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: bigint";
            }
            if (tuple2 != null && FloatType$.MODULE$.equals(dataType6 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: float";
            }
            if (tuple2 != null && StringType$.MODULE$.equals(dataType5 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: string";
            }
            if (tuple2 != null && DoubleType$.MODULE$.equals(dataType4 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: double";
            }
            if (tuple2 != null && BooleanType$.MODULE$.equals(dataType3 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: boolean";
            }
            if (tuple2 != null && BinaryType$.MODULE$.equals(dataType2 = (DataType)tuple2._2()) && value == null) {
                return "NULL :: binary";
            }
            if (value == null) {
                return "NULL";
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType12 = (DataType)tuple2._2();
                if (v instanceof String) {
                    String string = (String)v;
                    if (StringType$.MODULE$.equals(dataType12)) {
                        return this.stringToSql(string);
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType13 = (DataType)tuple2._2();
                if (v instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte((Object)v);
                    if (ByteType$.MODULE$.equals(dataType13)) {
                        return new StringBuilder(11).append(by).append(" :: tinyint").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType14 = (DataType)tuple2._2();
                if (v instanceof Short) {
                    short s = BoxesRunTime.unboxToShort((Object)v);
                    if (ShortType$.MODULE$.equals(dataType14)) {
                        return new StringBuilder(12).append(s).append(" :: smallint").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType15 = (DataType)tuple2._2();
                if (v instanceof Object) {
                    Object object = v;
                    if (IntegerType$.MODULE$.equals(dataType15)) {
                        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(object), " :: int");
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType16 = (DataType)tuple2._2();
                if (v instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)v);
                    if (LongType$.MODULE$.equals(dataType16)) {
                        return new StringBuilder(10).append(l).append(" :: bigint").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType17 = (DataType)tuple2._2();
                if (v instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)v);
                    if (BooleanType$.MODULE$.equals(dataType17)) {
                        return new StringBuilder(11).append(bl).append(" :: boolean").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType18 = (DataType)tuple2._2();
                if (v instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)v);
                    if (FloatType$.MODULE$.equals(dataType18)) {
                        float f2 = f;
                        String castedValue = Float.isNaN(f) ? "'NaN'" : (Float.POSITIVE_INFINITY == f2 ? "'Infinity'" : (Float.NEGATIVE_INFINITY == f2 ? "'-Infinity'" : new StringBuilder(2).append("'").append(f).append("'").toString()));
                        return new StringBuilder(9).append(castedValue).append(" :: FLOAT").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType19 = (DataType)tuple2._2();
                if (v instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)v);
                    if (DoubleType$.MODULE$.equals(dataType19)) {
                        double d2 = d;
                        if (Double.isNaN(d)) {
                            return "'NaN'";
                        }
                        if (Double.POSITIVE_INFINITY == d2) {
                            return "'Infinity'";
                        }
                        if (Double.NEGATIVE_INFINITY == d2) {
                            return "'-Infinity'";
                        }
                        return new StringBuilder(8).append(d).append("::DOUBLE").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType t = (DataType)tuple2._2();
                if (v instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)v;
                    if (t instanceof DecimalType) {
                        DecimalType decimalType = (DecimalType)t;
                        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)bigDecimal), new StringBuilder(4).append(" :: ").append(package$.MODULE$.number(Predef$.MODULE$.int2Integer(decimalType.precision()), Predef$.MODULE$.int2Integer(decimalType.scale()))).toString());
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType t = (DataType)tuple2._2();
                if (v instanceof java.math.BigDecimal) {
                    java.math.BigDecimal bigDecimal = (java.math.BigDecimal)v;
                    if (t instanceof DecimalType) {
                        DecimalType decimalType = (DecimalType)t;
                        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)bigDecimal), new StringBuilder(4).append(" :: ").append(package$.MODULE$.number(Predef$.MODULE$.int2Integer(decimalType.precision()), Predef$.MODULE$.int2Integer(decimalType.scale()))).toString());
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType20 = (DataType)tuple2._2();
                if (v instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)v);
                    if (DateType$.MODULE$.equals(dataType20)) {
                        return new StringBuilder(7).append("DATE '").append(SnowflakeDateTimeFormat.fromSqlFormat((String)Utils$.MODULE$.DateInputFormat()).format((java.util.Date)new Date((long)n * this.MILLIS_PER_DAY()), TimeZone.getTimeZone("GMT"))).append("'").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType21 = (DataType)tuple2._2();
                if (v instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)v);
                    if (TimestampType$.MODULE$.equals(dataType21)) {
                        return new StringBuilder(12).append("TIMESTAMP '").append(SnowflakeDateTimeFormat.fromSqlFormat((String)Utils$.MODULE$.TimestampInputFormat()).format(new Timestamp(l / this.MICROS_PER_MILLIS()), TimeZone.getDefault(), 3)).append("'").toString();
                    }
                }
            }
            if (tuple2 != null) {
                Object v = tuple2._1();
                DataType dataType22 = (DataType)tuple2._2();
                if (v instanceof byte[]) {
                    byte[] byArray = (byte[])v;
                    if (BinaryType$.MODULE$.equals(dataType22)) {
                        return new StringBuilder(12).append("'").append(DatatypeConverter.printHexBinary((byte[])byArray)).append("' :: binary").toString();
                    }
                }
            }
            throw new UnsupportedOperationException(new StringBuilder(35).append("Unsupported datatype by ToSql: ").append(value.getClass().getName()).append(" => ").append(dataType).toString());
        }
        throw new MatchError(option);
    }

    public String schemaExpression(DataType dataType, boolean isNullable) {
        if (isNullable) {
            DataType dataType2 = dataType;
            if (GeographyType$.MODULE$.equals(dataType2)) {
                return "TRY_TO_GEOGRAPHY(NULL)";
            }
            if (dataType2 instanceof ArrayType) {
                return "PARSE_JSON('NULL')::ARRAY";
            }
            return new StringBuilder(8).append("NULL :: ").append(com.snowflake.snowpark.types.package$.MODULE$.convertToSFType(dataType)).toString();
        }
        DataType dataType3 = dataType;
        if (dataType3 instanceof NumericType) {
            return new StringBuilder(5).append("0 :: ").append(com.snowflake.snowpark.types.package$.MODULE$.convertToSFType(dataType)).toString();
        }
        if (StringType$.MODULE$.equals(dataType3)) {
            return "'a' :: STRING";
        }
        if (BinaryType$.MODULE$.equals(dataType3)) {
            return "to_binary(hex_encode(1))";
        }
        if (BooleanType$.MODULE$.equals(dataType3)) {
            return "true";
        }
        if (DateType$.MODULE$.equals(dataType3)) {
            return "date('2020-9-16')";
        }
        if (TimeType$.MODULE$.equals(dataType3)) {
            return "to_time('04:15:29.999')";
        }
        if (TimestampType$.MODULE$.equals(dataType3)) {
            return "to_timestamp_ntz('2020-09-16 06:30:00')";
        }
        if (dataType3 instanceof ArrayType) {
            return "to_array(0)";
        }
        if (dataType3 instanceof MapType) {
            return "to_object(parse_json('0'))";
        }
        if (VariantType$.MODULE$.equals(dataType3)) {
            return "to_variant(0)";
        }
        if (GeographyType$.MODULE$.equals(dataType3)) {
            return "to_geography('POINT(-122.35 37.55)')";
        }
        throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dataType.typeName()).toString());
    }

    public String toSqlWithoutCast(Object value, DataType dataType) {
        DataType dataType2 = dataType;
        if (value == null) {
            return "NULL";
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return new StringBuilder(2).append("'").append(value).append("'").toString();
        }
        return value.toString();
    }

    private DataTypeMapper$() {
        MODULE$ = this;
        this.MILLIS_PER_DAY = 86400000L;
        this.MICROS_PER_MILLIS = 1000L;
    }
}

