/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;

public final class DateTimeUtils$ {
    public static DateTimeUtils$ MODULE$;

    static {
        new DateTimeUtils$();
    }

    private final long SECONDS_PER_DAY() {
        return 86400L;
    }

    private final long MICROS_PER_MILLIS() {
        return 1000L;
    }

    private final long MICROS_PER_SECOND() {
        return 1000000L;
    }

    private final long NANOS_PER_MICROS() {
        return 1000L;
    }

    public long instantToMicros(Instant instant) {
        long us = Math.multiplyExact(instant.getEpochSecond(), 1000000L);
        long result = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
        return result;
    }

    public long javaTimestampToMicros(Timestamp t) {
        return Math.multiplyExact(t.getTime(), 1000L) + (long)t.getNanos() / 1000L % 1000L;
    }

    public int localDateToDays(LocalDate localDate) {
        return Math.toIntExact(localDate.toEpochDay());
    }

    public int javaDateToDays(Date date) {
        return this.localDateToDays(date.toLocalDate());
    }

    private DateTimeUtils$() {
        MODULE$ = this;
    }
}

