/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.analyzer.Alias;
import com.snowflake.snowpark.internal.analyzer.Alias$;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.Attribute$;
import com.snowflake.snowpark.internal.analyzer.ExprId;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.ExpressionAnalyzer$;
import com.snowflake.snowpark.internal.analyzer.NamedExpression;
import com.snowflake.snowpark.internal.analyzer.Star;
import com.snowflake.snowpark.internal.analyzer.UnresolvedAttribute;
import com.snowflake.snowpark.internal.analyzer.UnresolvedDFAliasAttribute;
import com.snowflake.snowpark.internal.analyzer.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=<aa\u0004\t\t\u0002QQbA\u0002\u000f\u0011\u0011\u0003!R\u0004C\u0003%\u0003\u0011\u0005a\u0005C\u0003(\u0003\u0011\u0005\u0001\u0006C\u0003(\u0003\u0011\u00051\rC\u0003(\u0003\u0011\u0005A\rC\u0003(\u0003\u0011\u0005!NB\u0003\u001d!\u0001!\"\u0006\u0003\u0005,\u000f\t\u0005\t\u0015!\u0003-\u0011!itA!A!\u0002\u0013q\u0004\"\u0002\u0013\b\t\u0003Y\u0005b\u0002(\b\u0005\u0004%Ia\u0014\u0005\u0007/\u001e\u0001\u000b\u0011\u0002)\t\u000ba;A\u0011A-\t\u000b};A\u0011\u00011\u0002%\u0015C\bO]3tg&|g.\u00118bYfTXM\u001d\u0006\u0003#I\t\u0001\"\u00198bYfTXM\u001d\u0006\u0003'Q\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003+Y\t\u0001b\u001d8poB\f'o\u001b\u0006\u0003/a\t\u0011b\u001d8po\u001ad\u0017m[3\u000b\u0003e\t1aY8n!\tY\u0012!D\u0001\u0011\u0005I)\u0005\u0010\u001d:fgNLwN\\!oC2L(0\u001a:\u0014\u0005\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005Q\u0012!B1qa2LHcA\u0015bEB\u00111dB\n\u0003\u000fy\t\u0001\"\u00197jCNl\u0015\r\u001d\t\u0005[Q:$H\u0004\u0002/eA\u0011q\u0006I\u0007\u0002a)\u0011\u0011'J\u0001\u0007yI|w\u000e\u001e \n\u0005M\u0002\u0013A\u0002)sK\u0012,g-\u0003\u00026m\t\u0019Q*\u00199\u000b\u0005M\u0002\u0003CA\u000e9\u0013\tI\u0004C\u0001\u0004FqB\u0014\u0018\n\u001a\t\u0003[mJ!\u0001\u0010\u001c\u0003\rM#(/\u001b8h\u0003)!g-\u00117jCNl\u0015\r\u001d\t\u0005[QRt\bE\u0002A\u000b\"s!!Q\"\u000f\u0005=\u0012\u0015\"A\u0011\n\u0005\u0011\u0003\u0013a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u00131aU3r\u0015\t!\u0005\u0005\u0005\u0002\u001c\u0013&\u0011!\n\u0005\u0002\n\u0003R$(/\u001b2vi\u0016$2!\u000b'N\u0011\u0015Y#\u00021\u0001-\u0011\u0015i$\u00021\u0001?\u0003E9WM\\3sCR,G-\u00117jCNl\u0015\r]\u000b\u0002!B!\u0011KV\u001c;\u001b\u0005\u0011&BA*U\u0003\u001diW\u000f^1cY\u0016T!!\u0016\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00026%\u0006\u0011r-\u001a8fe\u0006$X\rZ!mS\u0006\u001cX*\u00199!\u0003\u001d\tg.\u00197zu\u0016$\"AW/\u0011\u0005mY\u0016B\u0001/\u0011\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006=6\u0001\rAW\u0001\u0003Kb\f1bZ3u\u00032L\u0017m]'baV\tA\u0006C\u0003,\u0007\u0001\u0007A\u0006C\u0003>\u0007\u0001\u0007a\bF\u0001*)\u0011ISmZ5\t\u000b\u0019,\u0001\u0019\u0001\u0017\u0002\t5\f\u0007/\r\u0005\u0006Q\u0016\u0001\r\u0001L\u0001\u0005[\u0006\u0004(\u0007C\u0003>\u000b\u0001\u0007a\bF\u0002*W:DQ\u0001\u001c\u0004A\u00025\fA!\\1qgB\u0019\u0001)\u0012\u0017\t\u000bu2\u0001\u0019\u0001 ")
public class ExpressionAnalyzer {
    private final Map<ExprId, String> aliasMap;
    private final Map<String, Seq<Attribute>> dfAliasMap;
    private final scala.collection.mutable.Map<ExprId, String> generatedAliasMap;

    public static ExpressionAnalyzer apply(Seq<Map<ExprId, String>> seq, Map<String, Seq<Attribute>> map) {
        return ExpressionAnalyzer$.MODULE$.apply(seq, map);
    }

    public static ExpressionAnalyzer apply(Map<ExprId, String> map, Map<ExprId, String> map2, Map<String, Seq<Attribute>> map3) {
        return ExpressionAnalyzer$.MODULE$.apply(map, map2, map3);
    }

    public static ExpressionAnalyzer apply() {
        return ExpressionAnalyzer$.MODULE$.apply();
    }

    public static ExpressionAnalyzer apply(Map<ExprId, String> map, Map<String, Seq<Attribute>> map2) {
        return ExpressionAnalyzer$.MODULE$.apply(map, map2);
    }

    private scala.collection.mutable.Map<ExprId, String> generatedAliasMap() {
        return this.generatedAliasMap;
    }

    public Expression analyze(Expression ex) {
        boolean bl = false;
        Alias alias = null;
        Expression expression = ex;
        if (expression instanceof Attribute) {
            Attribute attribute = (Attribute)expression;
            String newName = (String)this.aliasMap.getOrElse((Object)attribute.exprId(), (Function0 & Serializable & scala.Serializable)() -> attribute.name());
            return Attribute$.MODULE$.apply(newName, attribute.dataType(), attribute.nullable(), attribute.exprId());
        }
        if (expression instanceof Alias) {
            bl = true;
            alias = (Alias)expression;
            Expression child = alias.child();
            String name = alias.name();
            if (child instanceof Attribute) {
                Attribute attribute = (Attribute)child;
                String quotedName = package$.MODULE$.quoteName(name);
                this.generatedAliasMap().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attribute.exprId()), (Object)quotedName));
                ((IterableLike)this.aliasMap.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExpressionAnalyzer.$anonfun$analyze$2(attribute, x$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        ExprId id = (ExprId)tuple2._1();
                        return (scala.collection.mutable.Map)this.generatedAliasMap().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id), (Object)quotedName));
                    }
                    throw new MatchError((Object)tuple2);
                });
                String string = package$.MODULE$.quoteName(attribute.name());
                String string2 = quotedName;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return attribute;
                }
                return new Alias(attribute, quotedName, Alias$.MODULE$.apply$default$3());
            }
        }
        if (bl) {
            Expression child = alias.child();
            String name = alias.name();
            if (child instanceof NamedExpression) {
                NamedExpression namedExpression = (NamedExpression)child;
                String string = package$.MODULE$.quoteName(namedExpression.name());
                String string3 = package$.MODULE$.quoteName(name);
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    return namedExpression;
                }
            }
        }
        if (expression instanceof UnresolvedDFAliasAttribute) {
            UnresolvedDFAliasAttribute unresolvedDFAliasAttribute = (UnresolvedDFAliasAttribute)expression;
            String name = unresolvedDFAliasAttribute.name();
            String[] colNameSplit = name.split("\\.", 2);
            if (colNameSplit.length > 1 && this.dfAliasMap.contains((Object)colNameSplit[0])) {
                String aliasColName;
                String normalizedColName;
                Seq aliasOutput = (Seq)this.dfAliasMap.apply((Object)colNameSplit[0]);
                Seq col = (Seq)aliasOutput.filter(arg_0 -> ExpressionAnalyzer.$anonfun$analyze$4$adapted(normalizedColName = package$.MODULE$.quoteName(aliasColName = colNameSplit[1]), arg_0));
                if (col.length() == 1) {
                    return ((Attribute)col.head()).withName(normalizedColName);
                }
                throw ErrorMessage$.MODULE$.DF_CANNOT_RESOLVE_COLUMN_NAME(aliasColName, (Traversable<String>)((Traversable)aliasOutput.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())));
            }
            String string = name;
            if ("*".equals(string)) {
                return new Star((Seq<NamedExpression>)((Seq)Nil$.MODULE$));
            }
            return new UnresolvedAttribute(package$.MODULE$.quoteName(name));
        }
        return ex;
    }

    public Map<ExprId, String> getAliasMap() {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply(this.aliasMap.toSeq());
        this.generatedAliasMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ExprId key = (ExprId)tuple2._1();
                String value = (String)tuple2._2();
                return (scala.collection.mutable.Map)result.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
            }
            throw new MatchError((Object)tuple2);
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$analyze$2(Attribute x8$1, Tuple2 x$1) {
        Object object = x$1._2();
        String string = x8$1.name();
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$analyze$4(String normalizedColName$1, Attribute attr) {
        return attr.name().equals(normalizedColName$1);
    }

    public ExpressionAnalyzer(Map<ExprId, String> aliasMap, Map<String, Seq<Attribute>> dfAliasMap) {
        this.aliasMap = aliasMap;
        this.dfAliasMap = dfAliasMap;
        this.generatedAliasMap = Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$analyze$4$adapted(String normalizedColName$1, Attribute attr) {
        return BoxesRunTime.boxToBoolean((boolean)ExpressionAnalyzer.$anonfun$analyze$4(normalizedColName$1, attr));
    }
}

