/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.analyzer.DateTimeUtils$;
import com.snowflake.snowpark.internal.analyzer.Literal;
import com.snowflake.snowpark.types.BinaryType$;
import com.snowflake.snowpark.types.BooleanType$;
import com.snowflake.snowpark.types.ByteType$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.DateType$;
import com.snowflake.snowpark.types.DecimalType$;
import com.snowflake.snowpark.types.DoubleType$;
import com.snowflake.snowpark.types.FloatType$;
import com.snowflake.snowpark.types.IntegerType$;
import com.snowflake.snowpark.types.LongType$;
import com.snowflake.snowpark.types.ShortType$;
import com.snowflake.snowpark.types.StringType$;
import com.snowflake.snowpark.types.TimestampType$;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.math.BigDecimal$;
import scala.runtime.BoxesRunTime;

public final class Literal$
implements Serializable {
    public static Literal$ MODULE$;
    private MathContext bigDecimalRoundContext;
    private volatile boolean bitmap$0;

    static {
        new Literal$();
    }

    private MathContext bigDecimalRoundContext$lzycompute() {
        Literal$ literal$ = this;
        synchronized (literal$) {
            if (!this.bitmap$0) {
                this.bigDecimalRoundContext = new MathContext(DecimalType$.MODULE$.MAX_PRECISION());
                this.bitmap$0 = true;
            }
        }
        return this.bigDecimalRoundContext;
    }

    private MathContext bigDecimalRoundContext() {
        if (!this.bitmap$0) {
            return this.bigDecimalRoundContext$lzycompute();
        }
        return this.bigDecimalRoundContext;
    }

    private scala.math.BigDecimal roundBigDecimal(scala.math.BigDecimal decimal) {
        return decimal.round(this.bigDecimalRoundContext());
    }

    public Literal apply(Object v) {
        Object object = v;
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return this.apply(BoxesRunTime.boxToInteger((int)n), (Option<DataType>)Option$.MODULE$.apply((Object)IntegerType$.MODULE$));
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return this.apply(BoxesRunTime.boxToLong((long)l), (Option<DataType>)Option$.MODULE$.apply((Object)LongType$.MODULE$));
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return this.apply(BoxesRunTime.boxToDouble((double)d), (Option<DataType>)Option$.MODULE$.apply((Object)DoubleType$.MODULE$));
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return this.apply(BoxesRunTime.boxToFloat((float)f), (Option<DataType>)Option$.MODULE$.apply((Object)FloatType$.MODULE$));
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return this.apply(BoxesRunTime.boxToByte((byte)by), (Option<DataType>)Option$.MODULE$.apply((Object)ByteType$.MODULE$));
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return this.apply(BoxesRunTime.boxToShort((short)s), (Option<DataType>)Option$.MODULE$.apply((Object)ShortType$.MODULE$));
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.apply(string, (Option<DataType>)Option$.MODULE$.apply((Object)StringType$.MODULE$));
        }
        if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            return this.apply(Character.toString(c), (Option<DataType>)Option$.MODULE$.apply((Object)StringType$.MODULE$));
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return this.apply(BoxesRunTime.boxToBoolean((boolean)bl), (Option<DataType>)Option$.MODULE$.apply((Object)BooleanType$.MODULE$));
        }
        if (object instanceof scala.math.BigDecimal) {
            scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
            scala.math.BigDecimal scalaDecimal = this.roundBigDecimal(bigDecimal);
            return this.apply(scalaDecimal, (Option<DataType>)Option$.MODULE$.apply((Object)DecimalType$.MODULE$.apply(scalaDecimal)));
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            scala.math.BigDecimal scalaDecimal = BigDecimal$.MODULE$.decimal(bigDecimal, this.bigDecimalRoundContext());
            return this.apply(scalaDecimal, (Option<DataType>)Option$.MODULE$.apply((Object)DecimalType$.MODULE$.apply(scalaDecimal)));
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return this.apply(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(instant)), (Option<DataType>)Option$.MODULE$.apply((Object)TimestampType$.MODULE$));
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return this.apply(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.javaTimestampToMicros(timestamp)), (Option<DataType>)Option$.MODULE$.apply((Object)TimestampType$.MODULE$));
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return this.apply(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(localDate)), (Option<DataType>)Option$.MODULE$.apply((Object)DateType$.MODULE$));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return this.apply(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.javaDateToDays(date)), (Option<DataType>)Option$.MODULE$.apply((Object)DateType$.MODULE$));
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return this.apply(byArray, (Option<DataType>)Option$.MODULE$.apply((Object)BinaryType$.MODULE$));
        }
        if (object == null) {
            return this.apply(null, (Option<DataType>)None$.MODULE$);
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            return literal;
        }
        throw ErrorMessage$.MODULE$.PLAN_CANNOT_CREATE_LITERAL(v.getClass().getCanonicalName(), String.valueOf(v));
    }

    public Literal apply(Object value, Option<DataType> dataTypeOption) {
        return new Literal(value, dataTypeOption);
    }

    public Option<Tuple2<Object, Option<DataType>>> unapply(Literal x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.value(), x$0.dataTypeOption()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Literal$() {
        MODULE$ = this;
    }
}

