/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.DataFrameWriterAsyncActor;
import com.snowflake.snowpark_java.Row;
import com.snowflake.snowpark_java.SaveMode;
import com.snowflake.snowpark_java.WriteFileResult;
import java.util.Map;

public class DataFrameWriter {
    private final com.snowflake.snowpark.DataFrameWriter writer;
    private final Session session;

    DataFrameWriter(com.snowflake.snowpark.DataFrameWriter writer, Session session) {
        this.writer = writer;
        this.session = session;
    }

    public DataFrameWriter option(String key, Object value) {
        this.writer.option(key, value);
        return this;
    }

    public DataFrameWriter options(Map<String, Object> configs) {
        this.writer.options(JavaUtils.javaStringAnyMapToScala(configs));
        return this;
    }

    public WriteFileResult csv(String path) {
        return new WriteFileResult(this.writer.csv(path));
    }

    private Row[] scalaRowArrayToJava(com.snowflake.snowpark.Row[] rows) {
        Row[] result = new Row[rows.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Row(rows[i]);
        }
        return result;
    }

    public WriteFileResult json(String path) {
        return new WriteFileResult(this.writer.json(path));
    }

    public WriteFileResult parquet(String path) {
        return new WriteFileResult(this.writer.parquet(path));
    }

    public void saveAsTable(String tableName) {
        this.writer.saveAsTable(tableName);
    }

    public void saveAsTable(String[] multipartIdentifier) {
        this.writer.saveAsTable(JavaUtils.stringArrayToStringSeq(multipartIdentifier));
    }

    public DataFrameWriter mode(String saveMode) {
        this.writer.mode(saveMode);
        return this;
    }

    public DataFrameWriter mode(SaveMode saveMode) {
        this.writer.mode(JavaUtils.javaSaveModeToScala(saveMode));
        return this;
    }

    public DataFrameWriterAsyncActor async() {
        return new DataFrameWriterAsyncActor(this.writer.async(), this.session);
    }
}

