/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark;

import com.snowflake.snowpark.CopyableDataFrame;
import com.snowflake.snowpark.DataFrame;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.analyzer.StagedFileReader;
import com.snowflake.snowpark.types.StructType;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e4A\u0001E\t\u00011!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0004)\u0001\t\u0007I\u0011B\u0015\t\rI\u0002\u0001\u0015!\u0003+\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015i\u0007\u0001\"\u0001o\u0011\u0015!\b\u0001\"\u0003v\u0005=!\u0015\r^1Ge\u0006lWMU3bI\u0016\u0014(B\u0001\n\u0014\u0003!\u0019hn\\<qCJ\\'B\u0001\u000b\u0016\u0003%\u0019hn\\<gY\u0006\\WMC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\bg\u0016\u001c8/[8o!\t\t#%D\u0001\u0012\u0013\t\u0019\u0013CA\u0004TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\"\u0001!)qD\u0001a\u0001A\u0005\u00012\u000f^1hK\u00124\u0015\u000e\\3SK\u0006$WM]\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\tC:\fG.\u001f>fe*\u0011q&E\u0001\tS:$XM\u001d8bY&\u0011\u0011\u0007\f\u0002\u0011'R\fw-\u001a3GS2,'+Z1eKJ\f\u0011c\u001d;bO\u0016$g)\u001b7f%\u0016\fG-\u001a:!\u0003\u0015!\u0018M\u00197f)\t)\u0004\b\u0005\u0002\"m%\u0011q'\u0005\u0002\n\t\u0006$\u0018M\u0012:b[\u0016DQ!O\u0003A\u0002i\nAA\\1nKB\u00111H\u0011\b\u0003y\u0001\u0003\"!P\u000e\u000e\u0003yR!aP\f\u0002\rq\u0012xn\u001c;?\u0013\t\t5$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!\u001c\u0003\u0019\u00198\r[3nCR\u0011ae\u0012\u0005\u0006\u000b\u001a\u0001\r\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017F\tQ\u0001^=qKNL!!\u0014&\u0003\u0015M#(/^2u)f\u0004X-A\u0002dgZ$\"\u0001U*\u0011\u0005\u0005\n\u0016B\u0001*\u0012\u0005E\u0019u\u000e]=bE2,G)\u0019;b\rJ\fW.\u001a\u0005\u0006)\u001e\u0001\rAO\u0001\u0005a\u0006$\b.\u0001\u0003kg>tGC\u0001)X\u0011\u0015!\u0006\u00021\u0001;\u0003\u0011\tgO]8\u0015\u0005AS\u0006\"\u0002+\n\u0001\u0004Q\u0014a\u00029beF,X\r\u001e\u000b\u0003!vCQ\u0001\u0016\u0006A\u0002i\n1a\u001c:d)\t\u0001\u0006\rC\u0003U\u0017\u0001\u0007!(A\u0002y[2$\"\u0001U2\t\u000bQc\u0001\u0019\u0001\u001e\u0002\r=\u0004H/[8o)\r1c\r\u001b\u0005\u0006O6\u0001\rAO\u0001\u0004W\u0016L\b\"B5\u000e\u0001\u0004Q\u0017!\u0002<bYV,\u0007C\u0001\u000el\u0013\ta7DA\u0002B]f\fqa\u001c9uS>t7\u000f\u0006\u0002'_\")\u0001O\u0004a\u0001c\u000691m\u001c8gS\u001e\u001c\b\u0003B\u001esu)L!a\u001d#\u0003\u00075\u000b\u0007/\u0001\fsK\u0006$7+Z7j'R\u0014Xo\u0019;ve\u0016$g)\u001b7f)\r\u0001fo\u001e\u0005\u0006)>\u0001\rA\u000f\u0005\u0006q>\u0001\rAO\u0001\u0007M>\u0014X.\u0019;")
public class DataFrameReader {
    private final Session session;
    private final StagedFileReader stagedFileReader;

    private StagedFileReader stagedFileReader() {
        return this.stagedFileReader;
    }

    public DataFrame table(String name) {
        return this.session.table(name);
    }

    public DataFrameReader schema(StructType schema) {
        this.stagedFileReader().userSchema(schema);
        return this;
    }

    public CopyableDataFrame csv(String path) {
        this.stagedFileReader().path(path).format("csv").databaseSchema(this.session.getFullyQualifiedCurrentSchema());
        return new CopyableDataFrame(this.session, this.stagedFileReader().createSnowflakePlan(), (Seq<String>)((Seq)Nil$.MODULE$), this.stagedFileReader());
    }

    public CopyableDataFrame json(String path) {
        return this.readSemiStructuredFile(path, "JSON");
    }

    public CopyableDataFrame avro(String path) {
        return this.readSemiStructuredFile(path, "AVRO");
    }

    public CopyableDataFrame parquet(String path) {
        return this.readSemiStructuredFile(path, "PARQUET");
    }

    public CopyableDataFrame orc(String path) {
        return this.readSemiStructuredFile(path, "ORC");
    }

    public CopyableDataFrame xml(String path) {
        return this.readSemiStructuredFile(path, "XML");
    }

    public DataFrameReader option(String key, Object value) {
        this.stagedFileReader().option(key, value);
        return this;
    }

    public DataFrameReader options(Map<String, Object> configs) {
        this.stagedFileReader().options(configs);
        return this;
    }

    private CopyableDataFrame readSemiStructuredFile(String path, String format) {
        this.stagedFileReader().path(path).format(format).databaseSchema(this.session.getFullyQualifiedCurrentSchema());
        return new CopyableDataFrame(this.session, this.stagedFileReader().createSnowflakePlan(), (Seq<String>)((Seq)Nil$.MODULE$), this.stagedFileReader());
    }

    public DataFrameReader(Session session) {
        this.session = session;
        this.stagedFileReader = new StagedFileReader(session);
    }
}

