/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal.analyzer;

import com.snowflake.snowpark.Row;
import com.snowflake.snowpark.SaveMode;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.Logging;
import com.snowflake.snowpark.internal.SnowflakeUDF;
import com.snowflake.snowpark.internal.analyzer.Aggregate;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.BinaryExpression;
import com.snowflake.snowpark.internal.analyzer.CaseWhen;
import com.snowflake.snowpark.internal.analyzer.Collate;
import com.snowflake.snowpark.internal.analyzer.CopyIntoLocation;
import com.snowflake.snowpark.internal.analyzer.CopyIntoNode;
import com.snowflake.snowpark.internal.analyzer.CreateViewCommand;
import com.snowflake.snowpark.internal.analyzer.DataTypeMapper$;
import com.snowflake.snowpark.internal.analyzer.DataframeAlias;
import com.snowflake.snowpark.internal.analyzer.DeleteMergeExpression;
import com.snowflake.snowpark.internal.analyzer.Except;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.Filter;
import com.snowflake.snowpark.internal.analyzer.FrameType;
import com.snowflake.snowpark.internal.analyzer.FunctionExpression;
import com.snowflake.snowpark.internal.analyzer.Generator;
import com.snowflake.snowpark.internal.analyzer.GroupingSetsExpression;
import com.snowflake.snowpark.internal.analyzer.InExpression;
import com.snowflake.snowpark.internal.analyzer.InsertMergeExpression;
import com.snowflake.snowpark.internal.analyzer.Intersect;
import com.snowflake.snowpark.internal.analyzer.Join;
import com.snowflake.snowpark.internal.analyzer.JoinType;
import com.snowflake.snowpark.internal.analyzer.Lateral;
import com.snowflake.snowpark.internal.analyzer.Like;
import com.snowflake.snowpark.internal.analyzer.Limit;
import com.snowflake.snowpark.internal.analyzer.LimitOnSort;
import com.snowflake.snowpark.internal.analyzer.ListAgg;
import com.snowflake.snowpark.internal.analyzer.Literal;
import com.snowflake.snowpark.internal.analyzer.LocalTempView$;
import com.snowflake.snowpark.internal.analyzer.LogicalPlan;
import com.snowflake.snowpark.internal.analyzer.MergeExpression;
import com.snowflake.snowpark.internal.analyzer.MultipleExpression;
import com.snowflake.snowpark.internal.analyzer.NamedExpression;
import com.snowflake.snowpark.internal.analyzer.NullOrdering;
import com.snowflake.snowpark.internal.analyzer.PersistedView$;
import com.snowflake.snowpark.internal.analyzer.Pivot;
import com.snowflake.snowpark.internal.analyzer.Project;
import com.snowflake.snowpark.internal.analyzer.ProjectAndFilter;
import com.snowflake.snowpark.internal.analyzer.Query;
import com.snowflake.snowpark.internal.analyzer.Range;
import com.snowflake.snowpark.internal.analyzer.RegExp;
import com.snowflake.snowpark.internal.analyzer.ScalarSubquery;
import com.snowflake.snowpark.internal.analyzer.SimplifiedUnion;
import com.snowflake.snowpark.internal.analyzer.SimplifiedUnionAll;
import com.snowflake.snowpark.internal.analyzer.SnowflakeCreateTable;
import com.snowflake.snowpark.internal.analyzer.SnowflakePlan;
import com.snowflake.snowpark.internal.analyzer.SnowflakeSampleNode;
import com.snowflake.snowpark.internal.analyzer.SnowflakeValues;
import com.snowflake.snowpark.internal.analyzer.Sort;
import com.snowflake.snowpark.internal.analyzer.SortDirection;
import com.snowflake.snowpark.internal.analyzer.SortOrder;
import com.snowflake.snowpark.internal.analyzer.SpecialFrameBoundary;
import com.snowflake.snowpark.internal.analyzer.SpecifiedWindowFrame;
import com.snowflake.snowpark.internal.analyzer.SqlGenerator$BinaryOperatorExtractor$;
import com.snowflake.snowpark.internal.analyzer.SqlGenerator$GroupingExtractor$;
import com.snowflake.snowpark.internal.analyzer.SqlGenerator$SpecialFrameBoundaryExtractor$;
import com.snowflake.snowpark.internal.analyzer.SqlGenerator$TableFunctionExpressionExtractor$;
import com.snowflake.snowpark.internal.analyzer.SqlGenerator$UnaryExpressionExtractor$;
import com.snowflake.snowpark.internal.analyzer.StagedFileReader;
import com.snowflake.snowpark.internal.analyzer.StagedFileWriter;
import com.snowflake.snowpark.internal.analyzer.Star;
import com.snowflake.snowpark.internal.analyzer.StoredProcedureRelation;
import com.snowflake.snowpark.internal.analyzer.SubfieldInt;
import com.snowflake.snowpark.internal.analyzer.SubfieldString;
import com.snowflake.snowpark.internal.analyzer.TableDelete;
import com.snowflake.snowpark.internal.analyzer.TableFunctionExpression;
import com.snowflake.snowpark.internal.analyzer.TableFunctionJoin;
import com.snowflake.snowpark.internal.analyzer.TableFunctionRelation;
import com.snowflake.snowpark.internal.analyzer.TableMerge;
import com.snowflake.snowpark.internal.analyzer.TableUpdate;
import com.snowflake.snowpark.internal.analyzer.UnaryExpression;
import com.snowflake.snowpark.internal.analyzer.UnresolvedAttribute;
import com.snowflake.snowpark.internal.analyzer.UnresolvedRelation;
import com.snowflake.snowpark.internal.analyzer.UnspecifiedFrame$;
import com.snowflake.snowpark.internal.analyzer.UpdateMergeExpression;
import com.snowflake.snowpark.internal.analyzer.ViewType;
import com.snowflake.snowpark.internal.analyzer.WindowExpression;
import com.snowflake.snowpark.internal.analyzer.WindowFrame;
import com.snowflake.snowpark.internal.analyzer.WindowSpecDefinition;
import com.snowflake.snowpark.internal.analyzer.WithinGroup;
import com.snowflake.snowpark.internal.analyzer.package$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.IntegralType;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.util.DynamicVariable;

public final class SqlGenerator$
extends Logging {
    public static SqlGenerator$ MODULE$;
    private final DynamicVariable<ArrayBuffer<SnowflakePlan>> subqueryPlans;

    static {
        new SqlGenerator$();
    }

    public DynamicVariable<ArrayBuffer<SnowflakePlan>> subqueryPlans() {
        return this.subqueryPlans;
    }

    public SnowflakePlan generateSqlQuery(LogicalPlan plan, Session session) {
        return (SnowflakePlan)this.subqueryPlans().withValue((Object)ArrayBuffer$.MODULE$.empty(), (Function0 & Serializable & scala.Serializable)() -> {
            SnowflakePlan result;
            block0: {
                result = MODULE$.generate(plan, session);
                if (!((TraversableOnce)MODULE$.subqueryPlans().value()).nonEmpty()) break block0;
                result = result.withSubqueries((SnowflakePlan[])((TraversableOnce)MODULE$.subqueryPlans().value()).toArray(ClassTag$.MODULE$.apply(SnowflakePlan.class)));
            }
            return result;
        });
    }

    private SnowflakePlan generate(LogicalPlan plan2, Session session) {
        boolean bl = false;
        SnowflakeValues snowflakeValues = null;
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof SnowflakePlan) {
            SnowflakePlan snowflakePlan = (SnowflakePlan)logicalPlan;
            return snowflakePlan;
        }
        if (logicalPlan instanceof TableFunctionJoin) {
            TableFunctionJoin tableFunctionJoin = (TableFunctionJoin)logicalPlan;
            LogicalPlan child = tableFunctionJoin.child();
            TableFunctionExpression tableFunction = tableFunctionJoin.tableFunction();
            Option<WindowSpecDefinition> over = tableFunctionJoin.over();
            return session.plans().joinTableFunction(this.expressionToSql(tableFunction), SqlGenerator$.resolveChild$1(child, session), (Option<String>)over.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr)), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof TableFunctionRelation) {
            TableFunctionRelation tableFunctionRelation = (TableFunctionRelation)logicalPlan;
            TableFunctionExpression tableFunction = tableFunctionRelation.tableFunction();
            return session.plans().fromTableFunction(this.expressionToSql(tableFunction));
        }
        if (logicalPlan instanceof StoredProcedureRelation) {
            StoredProcedureRelation storedProcedureRelation = (StoredProcedureRelation)logicalPlan;
            String spName = storedProcedureRelation.spName();
            Seq<Expression> args = storedProcedureRelation.args();
            return session.plans().fromStoredProcedure(spName, (Seq<String>)((Seq)args.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (logicalPlan instanceof Lateral) {
            Lateral lateral = (Lateral)logicalPlan;
            LogicalPlan child = lateral.child();
            TableFunctionExpression tableFunction = lateral.tableFunction();
            return session.plans().lateral(this.expressionToSql(tableFunction), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)logicalPlan;
            Seq<Expression> groupingExpressions = aggregate.groupingExpressions();
            Seq<NamedExpression> aggregateExpressions = aggregate.aggregateExpressions();
            LogicalPlan child = aggregate.child();
            return session.plans().aggregate((Seq<String>)((Seq)groupingExpressions.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.toSqlAvoidOffset((Expression)exp), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)aggregateExpressions.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            Seq<NamedExpression> projectList = project.projectList();
            LogicalPlan child = project.child();
            return session.plans().project((Seq<String>)((Seq)projectList.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2), session.plans().project$default$4());
        }
        if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            Expression condition = filter.condition();
            LogicalPlan child = filter.child();
            return session.plans().filter(this.expressionToSql(condition), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof ProjectAndFilter) {
            ProjectAndFilter projectAndFilter = (ProjectAndFilter)logicalPlan;
            Seq<NamedExpression> projectList = projectAndFilter.projectList();
            Expression condition = projectAndFilter.condition();
            LogicalPlan child = projectAndFilter.child();
            return session.plans().projectAndFilter((Seq<String>)((Seq)projectList.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), this.expressionToSql(condition), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof SnowflakeSampleNode) {
            SnowflakeSampleNode snowflakeSampleNode = (SnowflakeSampleNode)logicalPlan;
            Option<Object> probabilityFraction = snowflakeSampleNode.probabilityFraction();
            Option<Object> rowCount = snowflakeSampleNode.rowCount();
            LogicalPlan child = snowflakeSampleNode.child();
            return session.plans().sample(probabilityFraction, rowCount, SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof Sort) {
            Sort sort = (Sort)logicalPlan;
            Seq<SortOrder> order = sort.order();
            LogicalPlan child = sort.child();
            return session.plans().sort((Seq<String>)((Seq)order.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof Intersect) {
            Intersect intersect = (Intersect)logicalPlan;
            LogicalPlan left = intersect.left();
            LogicalPlan right = intersect.right();
            return session.plans().setOperator(SqlGenerator$.resolveChild$1(left, session), SqlGenerator$.resolveChild$1(right, session), intersect.sql(), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof Except) {
            Except except = (Except)logicalPlan;
            LogicalPlan left = except.left();
            LogicalPlan right = except.right();
            return session.plans().setOperator(SqlGenerator$.resolveChild$1(left, session), SqlGenerator$.resolveChild$1(right, session), except.sql(), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof SimplifiedUnion) {
            SimplifiedUnion simplifiedUnion = (SimplifiedUnion)logicalPlan;
            Seq<LogicalPlan> children = simplifiedUnion.children();
            return session.plans().setOperator((Seq<SnowflakePlan>)((Seq)children.map((Function1 & Serializable & scala.Serializable)plan -> SqlGenerator$.resolveChild$1(plan, session), Seq$.MODULE$.canBuildFrom())), simplifiedUnion.sql(), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof SimplifiedUnionAll) {
            SimplifiedUnionAll simplifiedUnionAll = (SimplifiedUnionAll)logicalPlan;
            Seq<LogicalPlan> children = simplifiedUnionAll.children();
            return session.plans().setOperator((Seq<SnowflakePlan>)((Seq)children.map((Function1 & Serializable & scala.Serializable)plan -> SqlGenerator$.resolveChild$1(plan, session), Seq$.MODULE$.canBuildFrom())), simplifiedUnionAll.sql(), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof Join) {
            Join join = (Join)logicalPlan;
            LogicalPlan left = join.left();
            LogicalPlan right = join.right();
            JoinType joinType = join.joinType();
            Option<Expression> condition = join.condition();
            return session.plans().join(SqlGenerator$.resolveChild$1(left, session), SqlGenerator$.resolveChild$1(right, session), joinType, (Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr)), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof Range) {
            Range range = (Range)logicalPlan;
            long start = range.start();
            long end = range.end();
            long step = range.step();
            return session.plans().query(package$.MODULE$.rangeStatement(start, end, step, "id"), (Option<LogicalPlan>)new Some((Object)plan2), session.plans().query$default$3(), session.plans().query$default$4());
        }
        if (logicalPlan instanceof Generator) {
            Generator generator = (Generator)logicalPlan;
            Seq<Expression> exprs = generator.exprs();
            long rowCount = generator.rowCount();
            return session.plans().query(package$.MODULE$.generator((Seq<String>)((Seq)exprs.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), rowCount), (Option<LogicalPlan>)new Some((Object)plan2), session.plans().query$default$3(), session.plans().query$default$4());
        }
        if (logicalPlan instanceof SnowflakeValues) {
            bl = true;
            snowflakeValues = (SnowflakeValues)logicalPlan;
            Seq<Attribute> output = snowflakeValues.output();
            Seq<Row> data = snowflakeValues.data();
            if (data.isEmpty()) {
                return session.plans().query(package$.MODULE$.emptyValuesStatement(output), (Option<LogicalPlan>)new Some((Object)plan2), session.plans().query$default$3(), session.plans().query$default$4());
            }
        }
        if (bl) {
            Seq<Attribute> output = snowflakeValues.output();
            Seq<Row> data = snowflakeValues.data();
            if (output.size() * data.size() < 512) {
                return session.plans().query(package$.MODULE$.valuesStatement(output, data), (Option<LogicalPlan>)new Some((Object)plan2), session.plans().query$default$3(), session.plans().query$default$4());
            }
            return session.plans().largeLocalRelationPlan(output, data, (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
            String tableName = unresolvedRelation.name();
            return session.plans().table(tableName);
        }
        if (logicalPlan instanceof SnowflakeCreateTable) {
            SnowflakeCreateTable snowflakeCreateTable = (SnowflakeCreateTable)logicalPlan;
            String tableName = snowflakeCreateTable.tableName();
            SaveMode mode = snowflakeCreateTable.mode();
            Option<LogicalPlan> option = snowflakeCreateTable.query();
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalPlan child = (LogicalPlan)some.value();
                return session.plans().saveAsTable(tableName, mode, SqlGenerator$.resolveChild$1(child, session));
            }
        }
        if (logicalPlan instanceof CopyIntoLocation) {
            CopyIntoLocation copyIntoLocation = (CopyIntoLocation)logicalPlan;
            StagedFileWriter stagedFileWriter = copyIntoLocation.stagedFileWriter();
            LogicalPlan child = copyIntoLocation.child();
            return session.plans().copyIntoLocation(stagedFileWriter, SqlGenerator$.resolveChild$1(child, session));
        }
        if (logicalPlan instanceof Limit) {
            Limit limit = (Limit)logicalPlan;
            Expression offset = limit.limitExpr();
            LogicalPlan child = limit.child();
            return session.plans().limit(this.toSqlAvoidOffset(offset), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof LimitOnSort) {
            LimitOnSort limitOnSort = (LimitOnSort)logicalPlan;
            LogicalPlan child = limitOnSort.child();
            Expression offset = limitOnSort.limitExpr();
            Seq<SortOrder> order = limitOnSort.order();
            return session.plans().limitOnSort(SqlGenerator$.resolveChild$1(child, session), this.toSqlAvoidOffset(offset), (Seq<String>)((Seq)order.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof TableUpdate) {
            TableUpdate tableUpdate = (TableUpdate)logicalPlan;
            String tableName = tableUpdate.tableName();
            Map<Expression, Expression> assignments = tableUpdate.assignments();
            Option<Expression> condition = tableUpdate.condition();
            Option<LogicalPlan> sourceData = tableUpdate.sourceData();
            return session.plans().update(tableName, (Map<String, String>)((Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Expression k = (Expression)tuple2._1();
                    Expression v = (Expression)tuple2._2();
                    return new Tuple2((Object)MODULE$.expressionToSql(k), (Object)MODULE$.expressionToSql(v));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom())), (Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr)), (Option<SnowflakePlan>)sourceData.map((Function1 & Serializable & scala.Serializable)plan -> SqlGenerator$.resolveChild$1(plan, session)));
        }
        if (logicalPlan instanceof TableDelete) {
            TableDelete tableDelete = (TableDelete)logicalPlan;
            String tableName = tableDelete.tableName();
            Option<Expression> condition = tableDelete.condition();
            Option<LogicalPlan> sourceData = tableDelete.sourceData();
            return session.plans().delete(tableName, (Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr)), (Option<SnowflakePlan>)sourceData.map((Function1 & Serializable & scala.Serializable)plan -> SqlGenerator$.resolveChild$1(plan, session)));
        }
        if (logicalPlan instanceof TableMerge) {
            TableMerge tableMerge = (TableMerge)logicalPlan;
            String tableName = tableMerge.tableName();
            LogicalPlan source = tableMerge.child();
            Expression joinExpr = tableMerge.joinExpr();
            Seq<MergeExpression> clauses = tableMerge.clauses();
            return session.plans().merge(tableName, SqlGenerator$.resolveChild$1(source, session), this.expressionToSql(joinExpr), (Seq<String>)((Seq)clauses.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (logicalPlan instanceof Pivot) {
            Pivot pivot = (Pivot)logicalPlan;
            Expression pivotColumn = pivot.pivotColumn();
            Seq<Expression> pivotValues = pivot.pivotValues();
            Seq<Expression> aggregates = pivot.aggregates();
            LogicalPlan child = pivot.child();
            Predef$.MODULE$.require(aggregates.size() == 1, (Function0 & Serializable & scala.Serializable)() -> "Only one aggregate is supported with pivot");
            return session.plans().pivot(this.expressionToSql(pivotColumn), (Seq<String>)((Seq)pivotValues.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), this.expressionToSql((Expression)aggregates.head()), SqlGenerator$.resolveChild$1(child, session), (Option<LogicalPlan>)new Some((Object)plan2));
        }
        if (logicalPlan instanceof CreateViewCommand) {
            boolean bl2;
            CreateViewCommand createViewCommand = (CreateViewCommand)logicalPlan;
            String name = createViewCommand.name();
            LogicalPlan child = createViewCommand.child();
            ViewType viewType = createViewCommand.viewType();
            ViewType viewType2 = viewType;
            if (PersistedView$.MODULE$.equals(viewType2)) {
                bl2 = false;
            } else if (LocalTempView$.MODULE$.equals(viewType2)) {
                bl2 = true;
            } else {
                throw ErrorMessage$.MODULE$.PLAN_ANALYZER_UNSUPPORTED_VIEW_TYPE(viewType.toString());
            }
            boolean isTemp = bl2;
            return session.plans().createOrReplaceView(name, SqlGenerator$.resolveChild$1(child, session), isTemp);
        }
        if (logicalPlan instanceof CopyIntoNode) {
            CopyIntoNode copyIntoNode = (CopyIntoNode)logicalPlan;
            String name = copyIntoNode.tableName();
            Seq<String> columnNames = copyIntoNode.columnNames();
            Seq<Expression> transformations = copyIntoNode.transformations();
            Map<String, Object> options = copyIntoNode.options();
            StagedFileReader stagedFileReader = copyIntoNode.stagedFileReader();
            return stagedFileReader.table(name).columnNames(columnNames).transformations(transformations).options(options).createSnowflakePlan();
        }
        if (logicalPlan instanceof DataframeAlias) {
            DataframeAlias dataframeAlias = (DataframeAlias)logicalPlan;
            LogicalPlan child = dataframeAlias.child();
            return SqlGenerator$.resolveChild$1(child, session);
        }
        throw new MatchError((Object)logicalPlan);
    }

    public String expressionToSql(Expression expr2) {
        ScalarSubquery scalarSubquery;
        SnowflakePlan plan;
        UnaryExpression unaryExpression;
        Option<String> option;
        BinaryExpression binaryExpression;
        Option<String> option2;
        SpecialFrameBoundary specialFrameBoundary;
        Option<String> option3;
        TableFunctionExpression tableFunctionExpression;
        Option<String> option4;
        Expression expression = expr2;
        if (expression instanceof GroupingSetsExpression) {
            GroupingSetsExpression groupingSetsExpression = (GroupingSetsExpression)expression;
            Seq<Set<Expression>> args = groupingSetsExpression.args();
            return package$.MODULE$.groupingSetExpression((Seq<Set<String>>)((Seq)args.map((Function1 & Serializable & scala.Serializable)x$1 -> (Set)x$1.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Set$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())));
        }
        if (expression instanceof TableFunctionExpression && !(option4 = SqlGenerator$TableFunctionExpressionExtractor$.MODULE$.unapply(tableFunctionExpression = (TableFunctionExpression)expression)).isEmpty()) {
            String str = (String)option4.get();
            return str;
        }
        if (expression instanceof SubfieldString) {
            SubfieldString subfieldString = (SubfieldString)expression;
            Expression expr3 = subfieldString.expr();
            String field = subfieldString.field();
            return package$.MODULE$.subfieldExpression(this.expressionToSql(expr3), field);
        }
        if (expression instanceof SubfieldInt) {
            SubfieldInt subfieldInt = (SubfieldInt)expression;
            Expression expr4 = subfieldInt.expr();
            int field = subfieldInt.field();
            return package$.MODULE$.subfieldExpression(this.expressionToSql(expr4), field);
        }
        if (expression instanceof Like) {
            Like like = (Like)expression;
            Expression expr5 = like.expr();
            Expression pattern = like.pattern();
            return package$.MODULE$.likeExpression(this.expressionToSql(expr5), this.expressionToSql(pattern));
        }
        if (expression instanceof RegExp) {
            RegExp regExp = (RegExp)expression;
            Expression expr6 = regExp.expr();
            Expression pattern = regExp.pattern();
            return package$.MODULE$.regexpExpression(this.expressionToSql(expr6), this.expressionToSql(pattern));
        }
        if (expression instanceof Collate) {
            Collate collate = (Collate)expression;
            Expression expr7 = collate.expr();
            String collationSpec = collate.collationSpec();
            return package$.MODULE$.collateExpression(this.expressionToSql(expr7), collationSpec);
        }
        if (expression instanceof SnowflakeUDF) {
            SnowflakeUDF snowflakeUDF = (SnowflakeUDF)expression;
            String name = snowflakeUDF.udfName();
            Seq<Expression> children = snowflakeUDF.children();
            return package$.MODULE$.functionExpression(name, (Seq<String>)((Seq)children.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), false);
        }
        if (expression instanceof CaseWhen) {
            String string;
            CaseWhen caseWhen = (CaseWhen)expression;
            Seq<Tuple2<Expression, Expression>> branches = caseWhen.branches();
            Option<Expression> elseValue = caseWhen.elseValue();
            Seq seq = (Seq)branches.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Expression condition = (Expression)tuple2._1();
                    Expression value = (Expression)tuple2._2();
                    return new Tuple2((Object)MODULE$.expressionToSql(condition), (Object)MODULE$.expressionToSql(value));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            Option<Expression> option5 = elseValue;
            if (option5 instanceof Some) {
                Some some = (Some)option5;
                Expression value = (Expression)some.value();
                string = this.expressionToSql(value);
            } else {
                string = "NULL";
            }
            return package$.MODULE$.caseWhenExpression((Seq<Tuple2<String, String>>)seq, string);
        }
        if (expression instanceof MultipleExpression) {
            MultipleExpression multipleExpression = (MultipleExpression)expression;
            Seq<Expression> expressions = multipleExpression.expressions();
            return package$.MODULE$.blockExpression((Seq<String>)((Seq)expressions.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (expression instanceof InExpression) {
            InExpression inExpression = (InExpression)expression;
            Expression column = inExpression.columns();
            Seq<Expression> values = inExpression.values();
            return package$.MODULE$.inExpression(this.expressionToSql(column), (Seq<String>)((Seq)values.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        Option<String> option6 = SqlGenerator$GroupingExtractor$.MODULE$.unapply(expression);
        if (!option6.isEmpty()) {
            String str = (String)option6.get();
            return str;
        }
        if (expression instanceof WindowExpression) {
            WindowExpression windowExpression = (WindowExpression)expression;
            Expression windowFunction = windowExpression.windowFunction();
            WindowSpecDefinition windowSpec = windowExpression.windowSpec();
            return package$.MODULE$.windowExpression(this.expressionToSql(windowFunction), this.expressionToSql(windowSpec));
        }
        if (expression instanceof WindowSpecDefinition) {
            WindowSpecDefinition windowSpecDefinition = (WindowSpecDefinition)expression;
            Seq<Expression> partitionSpec = windowSpecDefinition.partitionSpec();
            Seq<SortOrder> orderSpec = windowSpecDefinition.orderSpec();
            WindowFrame frameSpecification = windowSpecDefinition.frameSpecification();
            return package$.MODULE$.windowSpecExpressions((Seq<String>)((Seq)partitionSpec.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.toSqlAvoidOffset((Expression)exp), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)orderSpec.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.toSqlAvoidOffset((Expression)exp), Seq$.MODULE$.canBuildFrom())), this.expressionToSql(frameSpecification));
        }
        if (expression instanceof SpecifiedWindowFrame) {
            SpecifiedWindowFrame specifiedWindowFrame = (SpecifiedWindowFrame)expression;
            FrameType frameType = specifiedWindowFrame.frameType();
            Expression lower = specifiedWindowFrame.lower();
            Expression upper = specifiedWindowFrame.upper();
            return package$.MODULE$.specifiedWindowFrameExpression(frameType.sql(), this.windowFrameBoundary(this.toSqlAvoidOffset(lower)), this.windowFrameBoundary(this.toSqlAvoidOffset(upper)));
        }
        if (UnspecifiedFrame$.MODULE$.equals(expression)) {
            return "";
        }
        if (expression instanceof SpecialFrameBoundary && !(option3 = SqlGenerator$SpecialFrameBoundaryExtractor$.MODULE$.unapply(specialFrameBoundary = (SpecialFrameBoundary)expression)).isEmpty()) {
            String str = (String)option3.get();
            return str;
        }
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object value = literal.value();
            Option<DataType> dataType = literal.dataTypeOption();
            return DataTypeMapper$.MODULE$.toSql(value, dataType);
        }
        if (expression instanceof Attribute) {
            Attribute attribute = (Attribute)expression;
            return package$.MODULE$.quoteName(attribute.name());
        }
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            String name = unresolvedAttribute.name();
            return name;
        }
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            String name = functionExpression.name();
            Seq<Expression> children = functionExpression.arguments();
            boolean isDistinct = functionExpression.isDistinct();
            return package$.MODULE$.functionExpression(name, (Seq<String>)((Seq)children.map((Function1 & Serializable & scala.Serializable)exp -> MODULE$.toSqlAvoidOffset((Expression)exp), Seq$.MODULE$.canBuildFrom())), isDistinct);
        }
        if (expression instanceof Star) {
            Star star = (Star)expression;
            Seq<NamedExpression> columns = star.expressions();
            if (columns.isEmpty()) {
                return "*";
            }
            return ((TraversableOnce)columns.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())).mkString(",");
        }
        if (expression instanceof BinaryExpression && !(option2 = SqlGenerator$BinaryOperatorExtractor$.MODULE$.unapply(binaryExpression = (BinaryExpression)expression)).isEmpty()) {
            String str = (String)option2.get();
            return str;
        }
        if (expression instanceof SortOrder) {
            SortOrder sortOrder = (SortOrder)expression;
            Expression child = sortOrder.child();
            SortDirection direction = sortOrder.direction();
            NullOrdering nullOrdering = sortOrder.nullOrdering();
            return package$.MODULE$.orderExpression(this.expressionToSql(child), direction.sql(), nullOrdering.sql());
        }
        if (expression instanceof UnaryExpression && !(option = SqlGenerator$UnaryExpressionExtractor$.MODULE$.unapply(unaryExpression = (UnaryExpression)expression)).isEmpty()) {
            String str = (String)option.get();
            return str;
        }
        if (expression instanceof ScalarSubquery && (plan = (scalarSubquery = (ScalarSubquery)expression).plan()) != null) {
            SnowflakePlan snowflakePlan = plan;
            ((BufferLike)this.subqueryPlans().value()).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SnowflakePlan[]{snowflakePlan}));
            return package$.MODULE$.subqueryExpression(((Query)snowflakePlan.queries().last()).sql());
        }
        if (expression instanceof WithinGroup) {
            WithinGroup withinGroup = (WithinGroup)expression;
            Expression expr8 = withinGroup.expr();
            Seq<Expression> orderByExprs = withinGroup.orderByCols();
            return package$.MODULE$.withinGroupExpression(this.expressionToSql(expr8), (Seq<String>)((Seq)orderByExprs.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (expression instanceof InsertMergeExpression) {
            InsertMergeExpression insertMergeExpression = (InsertMergeExpression)expression;
            Option<Expression> condition = insertMergeExpression.condition();
            Seq<Expression> keys = insertMergeExpression.keys();
            Seq<Expression> values = insertMergeExpression.values();
            return package$.MODULE$.insertMergeStatement((Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr)), (Seq<String>)((Seq)keys.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)values.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr), Seq$.MODULE$.canBuildFrom())));
        }
        if (expression instanceof UpdateMergeExpression) {
            UpdateMergeExpression updateMergeExpression = (UpdateMergeExpression)expression;
            Option<Expression> condition = updateMergeExpression.condition();
            Map<Expression, Expression> assignments = updateMergeExpression.assignments();
            return package$.MODULE$.updateMergeStatement((Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr)), (Map<String, String>)((Map)assignments.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Expression k = (Expression)tuple2._1();
                    Expression v = (Expression)tuple2._2();
                    return new Tuple2((Object)MODULE$.expressionToSql(k), (Object)MODULE$.expressionToSql(v));
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom())));
        }
        if (expression instanceof DeleteMergeExpression) {
            DeleteMergeExpression deleteMergeExpression = (DeleteMergeExpression)expression;
            Option<Expression> condition = deleteMergeExpression.condition();
            return package$.MODULE$.deleteMergeStatement((Option<String>)condition.map((Function1 & Serializable & scala.Serializable)expr -> MODULE$.expressionToSql((Expression)expr)));
        }
        if (expression instanceof ListAgg) {
            ListAgg listAgg = (ListAgg)expression;
            Expression expr9 = listAgg.col();
            String delimiter = listAgg.delimiter();
            boolean isDistinct = listAgg.isDistinct();
            return package$.MODULE$.listAgg(this.expressionToSql(expr9), DataTypeMapper$.MODULE$.stringToSql(delimiter), isDistinct);
        }
        throw new UnsupportedOperationException(new StringBuilder(29).append("Expression ").append(expr2.toString()).append(" is not supported.").toString());
    }

    public String windowFrameBoundary(String offset) {
        String string;
        try {
            int num = new StringOps(Predef$.MODULE$.augmentString(offset)).toInt();
            string = package$.MODULE$.windowFrameBoundaryExpression(Integer.toString(RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(num))), num >= 0);
        }
        catch (Throwable throwable) {
            string = offset;
        }
        return string;
    }

    public String toSqlAvoidOffset(Expression exp) {
        Expression expression = exp;
        if (expression instanceof Literal) {
            Some some;
            DataType dataType;
            Literal literal = (Literal)expression;
            Object value = literal.value();
            Option<DataType> option = literal.dataTypeOption();
            if (option instanceof Some && (dataType = (DataType)(some = (Some)option).value()) instanceof IntegralType) {
                return DataTypeMapper$.MODULE$.toSqlWithoutCast(value, dataType);
            }
        }
        return this.expressionToSql(exp);
    }

    private final int ARRAY_BIND_THRESHOLD() {
        return 512;
    }

    private static final SnowflakePlan resolveChild$1(LogicalPlan plan, Session session$2) {
        return plan.getOrUpdateSnowflakePlan((Function0<SnowflakePlan>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.generateSqlQuery(plan, session$2));
    }

    private SqlGenerator$() {
        MODULE$ = this;
        this.subqueryPlans = new DynamicVariable((Object)ArrayBuffer$.MODULE$.empty());
    }
}

