/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.types.Geography;
import com.snowflake.snowpark_java.types.Geometry;
import com.snowflake.snowpark_java.types.InternalUtils;
import com.snowflake.snowpark_java.types.Variant;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public class Row
implements Serializable,
Cloneable {
    private final com.snowflake.snowpark.Row scalaRow;

    Row(com.snowflake.snowpark.Row row) {
        this.scalaRow = row;
    }

    public Row(Object[] values) {
        this(com.snowflake.snowpark.Row.fromArray(Row.javaObjectToScalaObject(values)));
    }

    private static Object[] javaObjectToScalaObject(Object[] input) {
        Object[] result = Arrays.copyOf(input, input.length);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] instanceof Variant) {
                result[i] = InternalUtils.toScalaVariant((Variant)result[i]);
                continue;
            }
            if (result[i] instanceof Variant[]) {
                Variant[] javaVariantArray = (Variant[])result[i];
                com.snowflake.snowpark.types.Variant[] resultArray = new com.snowflake.snowpark.types.Variant[javaVariantArray.length];
                for (int idx = 0; idx < resultArray.length; ++idx) {
                    resultArray[idx] = InternalUtils.toScalaVariant(javaVariantArray[idx]);
                }
                result[i] = resultArray;
                continue;
            }
            if (result[i] instanceof java.util.Map) {
                result[i] = JavaUtils.javaMapToScalaWithVariantConversion((java.util.Map)result[i]);
                continue;
            }
            if (result[i] instanceof Geography) {
                result[i] = com.snowflake.snowpark.types.Geography.fromGeoJSON(((Geography)result[i]).asGeoJSON());
                continue;
            }
            if (!(result[i] instanceof Geometry)) continue;
            result[i] = com.snowflake.snowpark.types.Geometry.fromGeoJSON(result[i].toString());
        }
        return result;
    }

    public List<Object> toList() {
        return JavaUtils.seqToList(this.scalaRow.toSeq());
    }

    public int size() {
        return this.scalaRow.size();
    }

    public Row clone() {
        Row cloned;
        try {
            cloned = (Row)super.clone();
        }
        catch (CloneNotSupportedException e) {
            cloned = new Row(this.scalaRow);
        }
        return cloned;
    }

    public boolean equals(Object other) {
        if (other instanceof Row) {
            Row otherRow = (Row)other;
            return this.scalaRow.equals(otherRow.scalaRow);
        }
        return false;
    }

    public int hashCode() {
        return this.scalaRow.hashCode();
    }

    public Object get(int index) {
        return Row.toJavaValue(this.scalaRow.get(index));
    }

    private static Object toJavaValue(Object value) {
        if (value instanceof com.snowflake.snowpark.types.Variant) {
            return InternalUtils.createVariant((com.snowflake.snowpark.types.Variant)value);
        }
        if (value instanceof com.snowflake.snowpark.types.Geography) {
            return Geography.fromGeoJSON(((com.snowflake.snowpark.types.Geography)value).asGeoJSON());
        }
        if (value instanceof com.snowflake.snowpark.types.Geometry) {
            return Geometry.fromGeoJSON(value.toString());
        }
        if (value instanceof com.snowflake.snowpark.types.Variant[]) {
            com.snowflake.snowpark.types.Variant[] scalaVariantArray = (com.snowflake.snowpark.types.Variant[])value;
            Variant[] resultArray = new Variant[scalaVariantArray.length];
            for (int idx = 0; idx < scalaVariantArray.length; ++idx) {
                resultArray[idx] = InternalUtils.createVariant(scalaVariantArray[idx]);
            }
            return resultArray;
        }
        if (value instanceof Map) {
            Map input = (Map)value;
            HashMap result = new HashMap();
            input.foreach(x -> result.put(x._1, Row.toJavaValue(x._2)));
            return result;
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            ArrayList<Object> result = new ArrayList<Object>(arr.length);
            for (Object x2 : arr) {
                result.add(Row.toJavaValue(x2));
            }
            return result;
        }
        if (value instanceof com.snowflake.snowpark.Row) {
            return new Row((com.snowflake.snowpark.Row)value);
        }
        return value;
    }

    public boolean isNullAt(int index) {
        return this.scalaRow.isNullAt(index);
    }

    public boolean getBoolean(int index) {
        return this.scalaRow.getBoolean(index);
    }

    public byte getByte(int index) {
        return this.scalaRow.getByte(index);
    }

    public short getShort(int index) {
        return this.scalaRow.getShort(index);
    }

    public int getInt(int index) {
        return this.scalaRow.getInt(index);
    }

    public long getLong(int index) {
        return this.scalaRow.getLong(index);
    }

    public float getFloat(int index) {
        return this.scalaRow.getFloat(index);
    }

    public double getDouble(int index) {
        return this.scalaRow.getDouble(index);
    }

    public String getString(int index) {
        return this.scalaRow.getString(index);
    }

    public byte[] getBinary(int index) {
        return this.scalaRow.getBinary(index);
    }

    public Date getDate(int index) {
        return this.scalaRow.getDate(index);
    }

    public Time getTime(int index) {
        return this.scalaRow.getTime(index);
    }

    public Timestamp getTimestamp(int index) {
        return this.scalaRow.getTimestamp(index);
    }

    public BigDecimal getDecimal(int index) {
        return this.scalaRow.getDecimal(index);
    }

    public Variant getVariant(int index) {
        return InternalUtils.createVariant(this.scalaRow.getVariant(index));
    }

    public Geography getGeography(int index) {
        return Geography.fromGeoJSON(this.scalaRow.getGeography(index).asGeoJSON());
    }

    public Geometry getGeometry(int index) {
        return Geometry.fromGeoJSON(this.scalaRow.getGeometry(index).toString());
    }

    public List<Variant> getListOfVariant(int index) {
        Seq<com.snowflake.snowpark.types.Variant> scalaSeq = this.scalaRow.getSeqOfVariant(index);
        ArrayList<Variant> result = new ArrayList<Variant>(scalaSeq.size());
        for (int i = 0; i < scalaSeq.size(); ++i) {
            result.add(InternalUtils.createVariant((com.snowflake.snowpark.types.Variant)scalaSeq.apply(i)));
        }
        return result;
    }

    public java.util.Map<String, Variant> getMapOfVariant(int index) {
        Map<String, com.snowflake.snowpark.types.Variant> scalaMap = this.scalaRow.getMapOfVariant(index);
        HashMap<String, Variant> result = new HashMap<String, Variant>();
        Seq keys = scalaMap.keys().toSeq();
        for (int i = 0; i < keys.size(); ++i) {
            result.put((String)keys.apply(i), InternalUtils.createVariant((com.snowflake.snowpark.types.Variant)scalaMap.apply((Object)((String)keys.apply(i)))));
        }
        return result;
    }

    public List<?> getList(int index) {
        return (List)this.get(index);
    }

    public java.util.Map<?, ?> getMap(int index) {
        return (java.util.Map)this.get(index);
    }

    public Row getObject(int index) {
        return (Row)this.get(index);
    }

    public int fieldIndex(String fieldName) {
        return this.scalaRow.fieldIndex(fieldName);
    }

    public <T> T getAs(int index, Class<T> clazz) throws ClassCastException, ArrayIndexOutOfBoundsException {
        if (this.isNullAt(index)) {
            return (T)this.get(index);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(this.getByte(index));
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(this.getDouble(index));
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(this.getFloat(index));
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(this.getInt(index));
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(this.getLong(index));
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(this.getShort(index));
        }
        if (clazz == Variant.class) {
            return (T)this.getVariant(index);
        }
        return (T)this.get(index);
    }

    public <T> T getAs(String fieldName, Class<T> clazz) {
        return this.getAs(this.scalaRow.fieldIndex(fieldName), clazz);
    }

    public String toString() {
        return this.scalaRow.toString();
    }

    public static Row create(Object ... values) {
        return new Row(values);
    }

    com.snowflake.snowpark.Row getScalaRow() {
        return this.scalaRow;
    }
}

